/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.Preconditions;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.PayloadStorage;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.netflix.conductor.common.validation.ErrorResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBase.class);
    protected final Client client;
    protected String root = "";
    protected ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    protected PayloadStorage payloadStorage;
    protected ConductorClientConfiguration conductorClientConfiguration;

    protected ClientBase() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null);
    }

    protected ClientBase(ClientConfig config) {
        this(config, new DefaultConductorClientConfiguration(), null);
    }

    protected ClientBase(ClientConfig config, ClientHandler handler) {
        this(config, new DefaultConductorClientConfiguration(), handler);
    }

    protected ClientBase(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler) {
        if (this.isNewerJacksonVersion()) {
            this.objectMapper.registerModule((Module)new JavaTimeModule());
        }
        JacksonJsonProvider provider = new JacksonJsonProvider(this.objectMapper);
        config.getSingletons().add(provider);
        this.client = handler == null ? Client.create((ClientConfig)config) : new Client(handler, config);
        this.conductorClientConfiguration = clientConfiguration;
        this.payloadStorage = new PayloadStorage(this);
    }

    private boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }

    public void setRootURI(String root) {
        this.root = root;
    }

    protected void delete(String url, Object ... uriVariables) {
        this.deleteWithUriVariables(null, url, uriVariables);
    }

    protected void deleteWithUriVariables(Object[] queryParams, String url, Object ... uriVariables) {
        this.delete(queryParams, url, uriVariables, null);
    }

    protected BulkResponse deleteWithRequestBody(Object[] queryParams, String url, Object body) {
        return this.delete(queryParams, url, null, body);
    }

    private BulkResponse delete(Object[] queryParams, String url, Object[] uriVariables, Object body) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            if (body != null) {
                return (BulkResponse)this.client.resource(uri).type(MediaType.APPLICATION_JSON_TYPE).delete(BulkResponse.class, body);
            }
            this.client.resource(uri).delete();
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    protected void put(String url, Object[] queryParams, Object request, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            this.getWebResourceBuilder(uri, request).put();
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
        }
    }

    protected void postForEntityWithRequestOnly(String url, Object request) {
        Class type = null;
        this.postForEntity(url, request, null, type, new Object[0]);
    }

    protected void postForEntityWithUriVariablesOnly(String url, Object ... uriVariables) {
        Class type = null;
        this.postForEntity(url, null, null, type, uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, (Object)responseType, (Function<WebResource.Builder, T>)((Function<WebResource.Builder, Object>)builder -> builder.post(responseType)), uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, responseType, (WebResource.Builder builder) -> builder.post(responseType), uriVariables);
    }

    private <T> T postForEntity(String url, Object request, Object[] queryParams, Object responseType, Function<WebResource.Builder, T> postWithEntity, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            WebResource.Builder webResourceBuilder = this.getWebResourceBuilder(uri, request);
            if (responseType == null) {
                webResourceBuilder.post();
                return null;
            }
            return postWithEntity.apply(webResourceBuilder);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    protected <T> T getForEntity(String url, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (ClientResponse response) -> response.getEntity(responseType), uriVariables);
    }

    protected <T> T getForEntity(String url, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (ClientResponse response) -> response.getEntity(responseType), uriVariables);
    }

    private <T> T getForEntity(String url, Object[] queryParams, Function<ClientResponse, T> entityProvider, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            ClientResponse clientResponse = (ClientResponse)this.client.resource(uri).accept(new String[]{"application/json", "text/plain"}).get(ClientResponse.class);
            if (clientResponse.getStatus() < 300) {
                return entityProvider.apply(clientResponse);
            }
            throw new UniformInterfaceException(clientResponse);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    protected String uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType payloadType, byte[] payloadBytes, long payloadSize) {
        Preconditions.checkArgument((payloadType.equals((Object)ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT) || payloadType.equals((Object)ExternalPayloadStorage.PayloadType.TASK_OUTPUT) ? 1 : 0) != 0, (Object)"Payload type must be workflow input or task output");
        ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.WRITE, payloadType, "");
        this.payloadStorage.upload(externalStorageLocation.getUri(), new ByteArrayInputStream(payloadBytes), payloadSize);
        return externalStorageLocation.getPath();
    }

    protected Map<String, Object> downloadFromExternalStorage(ExternalPayloadStorage.PayloadType payloadType, String path) {
        Map map;
        block8: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)path), (Object)"uri cannot be blank");
            ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.READ, payloadType, path);
            InputStream inputStream = this.payloadStorage.download(externalStorageLocation.getUri());
            try {
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMsg = String.format("Unable to download payload from external storage location: %s", path);
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(errorMsg, e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private WebResource.Builder getWebResourceBuilder(URI URI2, Object entity) {
        return (WebResource.Builder)((WebResource.Builder)this.client.resource(URI2).type("application/json").entity(entity)).accept(new String[]{"text/plain", "application/json"});
    }

    private void handleClientHandlerException(ClientHandlerException exception, URI uri) {
        String errorMessage = String.format("Unable to invoke Conductor API with uri: %s, failure to process request or response", uri);
        LOGGER.error(errorMessage, (Throwable)exception);
        throw new ConductorClientException(errorMessage, exception);
    }

    private void handleRuntimeException(RuntimeException exception, URI uri) {
        String errorMessage = String.format("Unable to invoke Conductor API with uri: %s, runtime exception occurred", uri);
        LOGGER.error(errorMessage, (Throwable)exception);
        throw new ConductorClientException(errorMessage, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUniformInterfaceException(UniformInterfaceException exception, URI uri) {
        ClientResponse clientResponse = exception.getResponse();
        if (clientResponse == null) {
            throw new ConductorClientException(String.format("Unable to invoke Conductor API with uri: %s", uri));
        }
        try {
            if (clientResponse.getStatus() < 300) {
                return;
            }
            try {
                ErrorResponse errorResponse;
                String errorMessage = (String)clientResponse.getEntity(String.class);
                LOGGER.error("Unable to invoke Conductor API with uri: {}, unexpected response from server: statusCode={}, responseBody='{}'.", new Object[]{uri, clientResponse.getStatus(), errorMessage});
                try {
                    errorResponse = (ErrorResponse)this.objectMapper.readValue(errorMessage, ErrorResponse.class);
                }
                catch (IOException e) {
                    throw new ConductorClientException(clientResponse.getStatus(), errorMessage);
                }
                throw new ConductorClientException(clientResponse.getStatus(), errorResponse);
            }
            catch (ConductorClientException e) {
                throw e;
            }
            catch (ClientHandlerException e) {
                this.handleClientHandlerException(e, uri);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, uri);
            }
        }
        finally {
            clientResponse.close();
        }
    }

    private void handleException(URI uri, RuntimeException e) {
        if (e instanceof UniformInterfaceException) {
            this.handleUniformInterfaceException((UniformInterfaceException)((Object)e), uri);
        } else if (e instanceof ClientHandlerException) {
            this.handleClientHandlerException((ClientHandlerException)((Object)e), uri);
        } else {
            this.handleRuntimeException(e, uri);
        }
    }

    private String clientResponseToString(ClientResponse response) {
        if (response == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[status: ").append(response.getStatus());
        builder.append(", media type: ").append(response.getType());
        if (response.getStatus() != 404) {
            try {
                String responseBody = (String)response.getEntity(String.class);
                if (responseBody != null) {
                    builder.append(", response body: ").append(responseBody);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        builder.append(", response headers: ").append(response.getHeaders());
        builder.append("]");
        return builder.toString();
    }

    private UriBuilder getURIBuilder(String path, Object[] queryParams) {
        if (path == null) {
            path = "";
        }
        UriBuilder builder = UriBuilder.fromPath((String)path);
        if (queryParams != null) {
            for (int i = 0; i < queryParams.length; i += 2) {
                String param = queryParams[i].toString();
                Object value = queryParams[i + 1];
                if (value == null) continue;
                if (value instanceof Collection) {
                    Object[] values = ((Collection)value).toArray();
                    builder.queryParam(param, values);
                    continue;
                }
                builder.queryParam(param, new Object[]{value});
            }
        }
        return builder;
    }
}

