/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.telemetry;

import com.google.common.base.Joiner;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsContainer {
    private static final String TASK_TYPE = "taskType";
    private static final String WORKFLOW_TYPE = "workflowType";
    private static final String WORKFLOW_VERSION = "version";
    private static final String EXCEPTION = "exception";
    private static final String ENTITY_NAME = "entityName";
    private static final String OPERATION = "operation";
    private static final String PAYLOAD_TYPE = "payload_type";
    private static final String TASK_EXECUTION_QUEUE_FULL = "task_execution_queue_full";
    private static final String TASK_POLL_ERROR = "task_poll_error";
    private static final String TASK_PAUSED = "task_paused";
    private static final String TASK_EXECUTE_ERROR = "task_execute_error";
    private static final String TASK_ACK_FAILED = "task_ack_failed";
    private static final String TASK_ACK_ERROR = "task_ack_error";
    private static final String TASK_UPDATE_ERROR = "task_update_error";
    private static final String TASK_POLL_COUNTER = "task_poll_counter";
    private static final String TASK_EXECUTE_TIME = "task_execute_time";
    private static final String TASK_POLL_TIME = "task_poll_time";
    private static final String TASK_RESULT_SIZE = "task_result_size";
    private static final String WORKFLOW_INPUT_SIZE = "workflow_input_size";
    private static final String EXTERNAL_PAYLOAD_USED = "external_payload_used";
    private static final String WORKFLOW_START_ERROR = "workflow_start_error";
    private static final String THREAD_UNCAUGHT_EXCEPTION = "thread_uncaught_exceptions";
    private static final Registry REGISTRY = Spectator.globalRegistry();
    private static final Map<String, Timer> TIMERS = new ConcurrentHashMap<String, Timer>();
    private static final Map<String, Counter> COUNTERS = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, AtomicLong> GAUGES = new ConcurrentHashMap<String, AtomicLong>();
    private static final String CLASS_NAME = MetricsContainer.class.getSimpleName();

    private MetricsContainer() {
    }

    public static Timer getPollTimer(String taskType) {
        return MetricsContainer.getTimer(TASK_POLL_TIME, TASK_TYPE, taskType);
    }

    public static Timer getExecutionTimer(String taskType) {
        return MetricsContainer.getTimer(TASK_EXECUTE_TIME, TASK_TYPE, taskType);
    }

    private static Timer getTimer(String name, String ... additionalTags) {
        String key = CLASS_NAME + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return TIMERS.computeIfAbsent(key, k -> {
            List<Tag> tagList = MetricsContainer.getTags(additionalTags);
            tagList.add((Tag)new BasicTag("unit", TimeUnit.MILLISECONDS.name()));
            return REGISTRY.timer(name, tagList);
        });
    }

    private static List<Tag> getTags(String[] additionalTags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.add((Tag)new BasicTag("class", CLASS_NAME));
        for (int j = 0; j < additionalTags.length - 1; ++j) {
            tagList.add((Tag)new BasicTag(additionalTags[j], additionalTags[j + 1]));
            ++j;
        }
        return tagList;
    }

    private static void incrementCount(String name, String ... additionalTags) {
        MetricsContainer.getCounter(name, additionalTags).increment();
    }

    private static Counter getCounter(String name, String ... additionalTags) {
        String key = CLASS_NAME + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return COUNTERS.computeIfAbsent(key, k -> {
            List<Tag> tags = MetricsContainer.getTags(additionalTags);
            return REGISTRY.counter(name, tags);
        });
    }

    private static AtomicLong getGauge(String name, String ... additionalTags) {
        String key = CLASS_NAME + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return GAUGES.computeIfAbsent(key, pollTimer -> {
            Id id = REGISTRY.createId(name, MetricsContainer.getTags(additionalTags));
            return (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)REGISTRY).withId(id)).monitorValue((Number)new AtomicLong(0L));
        });
    }

    public static void incrementTaskExecutionQueueFullCount(String taskType) {
        MetricsContainer.incrementCount(TASK_EXECUTION_QUEUE_FULL, TASK_TYPE, taskType);
    }

    public static void incrementUncaughtExceptionCount() {
        MetricsContainer.incrementCount(THREAD_UNCAUGHT_EXCEPTION, new String[0]);
    }

    public static void incrementTaskPollErrorCount(String taskType, Exception e) {
        MetricsContainer.incrementCount(TASK_POLL_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    public static void incrementTaskPausedCount(String taskType) {
        MetricsContainer.incrementCount(TASK_PAUSED, TASK_TYPE, taskType);
    }

    public static void incrementTaskExecutionErrorCount(String taskType, Throwable e) {
        MetricsContainer.incrementCount(TASK_EXECUTE_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    public static void incrementTaskAckFailedCount(String taskType) {
        MetricsContainer.incrementCount(TASK_ACK_FAILED, TASK_TYPE, taskType);
    }

    public static void incrementTaskAckErrorCount(String taskType, Exception e) {
        MetricsContainer.incrementCount(TASK_ACK_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    public static void recordTaskResultPayloadSize(String taskType, long payloadSize) {
        MetricsContainer.getGauge(TASK_RESULT_SIZE, TASK_TYPE, taskType).getAndSet(payloadSize);
    }

    public static void incrementTaskUpdateErrorCount(String taskType, Throwable t) {
        MetricsContainer.incrementCount(TASK_UPDATE_ERROR, TASK_TYPE, taskType, EXCEPTION, t.getClass().getSimpleName());
    }

    public static void incrementTaskPollCount(String taskType, int taskCount) {
        MetricsContainer.getCounter(TASK_POLL_COUNTER, TASK_TYPE, taskType).increment((long)taskCount);
    }

    public static void recordWorkflowInputPayloadSize(String workflowType, String version, long payloadSize) {
        MetricsContainer.getGauge(WORKFLOW_INPUT_SIZE, WORKFLOW_TYPE, workflowType, WORKFLOW_VERSION, version).getAndSet(payloadSize);
    }

    public static void incrementExternalPayloadUsedCount(String name, String operation, String payloadType) {
        MetricsContainer.incrementCount(EXTERNAL_PAYLOAD_USED, ENTITY_NAME, name, OPERATION, operation, PAYLOAD_TYPE, payloadType);
    }

    public static void incrementWorkflowStartErrorCount(String workflowType, Throwable t) {
        MetricsContainer.incrementCount(WORKFLOW_START_ERROR, WORKFLOW_TYPE, workflowType, EXCEPTION, t.getClass().getSimpleName());
    }
}

