/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.automator;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.automator.TaskPollExecutor;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.discovery.EurekaClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnerConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRunnerConfigurer.class);
    private static final String INVALID_THREAD_COUNT = "Invalid worker thread count specified, use either shared thread pool or config thread count per task";
    private static final String MISSING_TASK_THREAD_COUNT = "Missing task thread count config for %s";
    private ScheduledExecutorService scheduledExecutorService;
    private final EurekaClient eurekaClient;
    private final TaskClient taskClient;
    private final List<Worker> workers = new LinkedList<Worker>();
    private final int sleepWhenRetry;
    private final int updateRetryCount;
    private final int threadCount;
    private final int shutdownGracePeriodSeconds;
    private final String workerNamePrefix;
    private final Map<String, String> taskToDomain;
    private final Map<String, Integer> taskThreadCount;
    private TaskPollExecutor taskPollExecutor;

    private TaskRunnerConfigurer(Builder builder) {
        if (builder.threadCount != -1 && !builder.taskThreadCount.isEmpty()) {
            LOGGER.error(INVALID_THREAD_COUNT);
            throw new ConductorClientException(INVALID_THREAD_COUNT);
        }
        if (!builder.taskThreadCount.isEmpty()) {
            for (Worker worker : builder.workers) {
                if (!builder.taskThreadCount.containsKey(worker.getTaskDefName())) {
                    String message = String.format(MISSING_TASK_THREAD_COUNT, worker.getTaskDefName());
                    LOGGER.error(message);
                    throw new ConductorClientException(message);
                }
                this.workers.add(worker);
            }
            this.taskThreadCount = builder.taskThreadCount;
            this.threadCount = -1;
        } else {
            builder.workers.forEach(this.workers::add);
            this.taskThreadCount = builder.taskThreadCount;
            this.threadCount = builder.threadCount == -1 ? this.workers.size() : builder.threadCount;
        }
        this.eurekaClient = builder.eurekaClient;
        this.taskClient = builder.taskClient;
        this.sleepWhenRetry = builder.sleepWhenRetry;
        this.updateRetryCount = builder.updateRetryCount;
        this.workerNamePrefix = builder.workerNamePrefix;
        this.taskToDomain = builder.taskToDomain;
        this.shutdownGracePeriodSeconds = builder.shutdownGracePeriodSeconds;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public Map<String, Integer> getTaskThreadCount() {
        return this.taskThreadCount;
    }

    public int getShutdownGracePeriodSeconds() {
        return this.shutdownGracePeriodSeconds;
    }

    public int getSleepWhenRetry() {
        return this.sleepWhenRetry;
    }

    public int getUpdateRetryCount() {
        return this.updateRetryCount;
    }

    public String getWorkerNamePrefix() {
        return this.workerNamePrefix;
    }

    public synchronized void init() {
        this.taskPollExecutor = new TaskPollExecutor(this.eurekaClient, this.taskClient, this.threadCount, this.updateRetryCount, this.taskToDomain, this.workerNamePrefix, this.taskThreadCount);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(this.workers.size());
        this.workers.forEach(worker -> this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.taskPollExecutor.pollAndExecute((Worker)worker), worker.getPollingInterval(), worker.getPollingInterval(), TimeUnit.MILLISECONDS));
    }

    public void shutdown() {
        this.taskPollExecutor.shutdownExecutorService(this.scheduledExecutorService, this.shutdownGracePeriodSeconds);
    }

    public static class Builder {
        private String workerNamePrefix = "workflow-worker-%d";
        private int sleepWhenRetry = 500;
        private int updateRetryCount = 3;
        private int threadCount = -1;
        private int shutdownGracePeriodSeconds = 10;
        private final Iterable<Worker> workers;
        private EurekaClient eurekaClient;
        private final TaskClient taskClient;
        private Map<String, String> taskToDomain = new HashMap<String, String>();
        private Map<String, Integer> taskThreadCount = new HashMap<String, Integer>();

        public Builder(TaskClient taskClient, Iterable<Worker> workers) {
            Preconditions.checkNotNull((Object)taskClient, (Object)"TaskClient cannot be null");
            Preconditions.checkNotNull(workers, (Object)"Workers cannot be null");
            this.taskClient = taskClient;
            this.workers = workers;
        }

        public Builder withWorkerNamePrefix(String workerNamePrefix) {
            this.workerNamePrefix = workerNamePrefix;
            return this;
        }

        public Builder withSleepWhenRetry(int sleepWhenRetry) {
            this.sleepWhenRetry = sleepWhenRetry;
            return this;
        }

        public Builder withUpdateRetryCount(int updateRetryCount) {
            this.updateRetryCount = updateRetryCount;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount < 1) {
                throw new IllegalArgumentException("No. of threads cannot be less than 1");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withShutdownGracePeriodSeconds(int shutdownGracePeriodSeconds) {
            if (shutdownGracePeriodSeconds < 1) {
                throw new IllegalArgumentException("Seconds of shutdownGracePeriod cannot be less than 1");
            }
            this.shutdownGracePeriodSeconds = shutdownGracePeriodSeconds;
            return this;
        }

        public Builder withEurekaClient(EurekaClient eurekaClient) {
            this.eurekaClient = eurekaClient;
            return this;
        }

        public Builder withTaskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
            return this;
        }

        public Builder withTaskThreadCount(Map<String, Integer> taskThreadCount) {
            this.taskThreadCount = taskThreadCount;
            return this;
        }

        public TaskRunnerConfigurer build() {
            return new TaskRunnerConfigurer(this);
        }
    }
}

