/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MetadataClient
extends ClientBase {
    public MetadataClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public MetadataClient(ClientConfig clientConfig) {
        this(clientConfig, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public MetadataClient(ClientConfig clientConfig, ClientHandler clientHandler) {
        this(clientConfig, new DefaultConductorClientConfiguration(), clientHandler, new ClientFilter[0]);
    }

    public MetadataClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public MetadataClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(config, clientConfiguration, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public void registerWorkflowDef(WorkflowDef workflowDef) {
        Preconditions.checkNotNull((Object)workflowDef, (Object)"Worfklow definition cannot be null");
        this.postForEntityWithRequestOnly("metadata/workflow", workflowDef);
    }

    public void updateWorkflowDefs(List<WorkflowDef> workflowDefs) {
        Preconditions.checkNotNull(workflowDefs, (Object)"Workflow defs list cannot be null");
        this.put("metadata/workflow", null, workflowDefs, new Object[0]);
    }

    public WorkflowDef getWorkflowDef(String name, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        return this.getForEntity("metadata/workflow/{name}", new Object[]{"version", version}, WorkflowDef.class, name);
    }

    public void unregisterWorkflowDef(String name, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Workflow name cannot be blank");
        Preconditions.checkNotNull((Object)version, (Object)"Version cannot be null");
        this.delete("metadata/workflow/{name}/{version}", name, version);
    }

    public void registerTaskDefs(List<TaskDef> taskDefs) {
        Preconditions.checkNotNull(taskDefs, (Object)"Task defs list cannot be null");
        this.postForEntityWithRequestOnly("metadata/taskdefs", taskDefs);
    }

    public void updateTaskDef(TaskDef taskDef) {
        Preconditions.checkNotNull((Object)taskDef, (Object)"Task definition cannot be null");
        this.put("metadata/taskdefs", null, taskDef, new Object[0]);
    }

    public TaskDef getTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        return this.getForEntity("metadata/taskdefs/{tasktype}", null, TaskDef.class, taskType);
    }

    public void unregisterTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        this.delete("metadata/taskdefs/{tasktype}", taskType);
    }
}

