/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EventClient
extends ClientBase {
    private static final GenericType<List<EventHandler>> eventHandlerList = new GenericType<List<EventHandler>>(){};

    public EventClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public EventClient(ClientConfig clientConfig) {
        this(clientConfig, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public EventClient(ClientConfig clientConfig, ClientHandler clientHandler) {
        this(clientConfig, new DefaultConductorClientConfiguration(), clientHandler, new ClientFilter[0]);
    }

    public EventClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public EventClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(config, clientConfiguration, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler, (Object)"Event Handler definition cannot be null");
        this.postForEntityWithRequestOnly("event", eventHandler);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler, (Object)"Event Handler definition cannot be null");
        this.put("event", null, eventHandler, new Object[0]);
    }

    public List<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)event), (Object)"Event cannot be blank");
        return this.getForEntity("event/{event}", new Object[]{"activeOnly", activeOnly}, eventHandlerList, event);
    }

    public void unregisterEventHandler(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Event handler name cannot be blank");
        this.delete("event/{name}", name);
    }
}

