/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.exception.RequestHandlerException;
import com.netflix.conductor.client.http.RequestHandler;
import com.netflix.conductor.client.http.jersey.JerseyRequestHandler;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.netflix.conductor.common.validation.ErrorResponse;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBase.class);
    private final RequestHandler requestHandler;
    private String root = "";
    protected final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private final PayloadStorage payloadStorage;
    protected final ConductorClientConfiguration conductorClientConfiguration;

    protected ClientBase(RequestHandler requestHandler, ConductorClientConfiguration clientConfiguration) {
        if (this.isNewerJacksonVersion()) {
            this.objectMapper.registerModule((Module)new JavaTimeModule());
        }
        this.requestHandler = requestHandler != null ? requestHandler : new JerseyRequestHandler();
        this.conductorClientConfiguration = (ConductorClientConfiguration)ObjectUtils.defaultIfNull((Object)clientConfiguration, (Object)new DefaultConductorClientConfiguration());
        this.payloadStorage = new PayloadStorage();
    }

    public void setRootURI(String root) {
        this.root = root;
    }

    protected void delete(String url, Object ... uriVariables) {
        this.deleteWithUriVariables(url, null, uriVariables);
    }

    protected void deleteWithUriVariables(String url, Object[] queryParams, Object ... uriVariables) {
        URI uri = this.getURIBuilder(this.getFullUrl(url), queryParams).build(uriVariables);
        try {
            this.requestHandler.delete(uri);
        }
        catch (RequestHandlerException rhe) {
            throw this.createClientException(rhe);
        }
    }

    protected void put(String url, Object[] queryParams, Object request, Object ... uriVariables) {
        URI uri = this.getURIBuilder(this.getFullUrl(url), queryParams).build(uriVariables);
        try {
            this.requestHandler.put(uri, request);
        }
        catch (RequestHandlerException rhe) {
            throw this.createClientException(rhe);
        }
    }

    protected void post(String url, Object request) {
        this.postForEntity(url, request, null, null, new Object[0]);
    }

    protected void postWithUriVariables(String url, Object ... uriVariables) {
        this.postForEntity(url, null, null, null, uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        URI uri = this.getURIBuilder(this.getFullUrl(url), queryParams).build(uriVariables);
        try {
            InputStream response = this.requestHandler.post(uri, request);
            if (responseType == null) {
                return null;
            }
            return this.convertToType(response, responseType);
        }
        catch (RequestHandlerException rhe) {
            throw this.createClientException(rhe);
        }
    }

    protected String postForString(String url, Object request, Object[] queryParams, Object ... uriVariables) {
        URI uri = this.getURIBuilder(this.getFullUrl(url), queryParams).build(uriVariables);
        try {
            InputStream response = this.requestHandler.post(uri, request);
            return this.convertToString(response);
        }
        catch (RequestHandlerException rhe) {
            throw this.createClientException(rhe);
        }
    }

    protected <T> T getForEntity(String url, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return this.getForEntity(url, queryParams, uriVariables).map(inputStream -> this.convertToType((InputStream)inputStream, responseType)).orElse(null);
    }

    protected <T> T getForEntity(String url, Object[] queryParams, TypeReference<T> responseType, Object ... uriVariables) {
        return this.getForEntity(url, queryParams, uriVariables).map(inputStream -> this.convertToType((InputStream)inputStream, responseType)).orElse(null);
    }

    protected String uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType payloadType, byte[] payloadBytes, long payloadSize) {
        Validate.isTrue((payloadType.equals((Object)ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT) || payloadType.equals((Object)ExternalPayloadStorage.PayloadType.TASK_OUTPUT) ? 1 : 0) != 0, (String)"Payload type must be workflow input or task output", (Object[])new Object[0]);
        ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.WRITE, payloadType, "");
        this.payloadStorage.upload(externalStorageLocation.getUri(), new ByteArrayInputStream(payloadBytes), payloadSize);
        return externalStorageLocation.getPath();
    }

    protected Map<String, Object> downloadFromExternalStorage(ExternalPayloadStorage.PayloadType payloadType, String path) {
        Map map;
        block8: {
            Validate.notBlank((CharSequence)path, (String)"uri cannot be blank", (Object[])new Object[0]);
            ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.READ, payloadType, path);
            InputStream inputStream = this.payloadStorage.download(externalStorageLocation.getUri());
            try {
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMsg = String.format("Unable to download payload from external storage location: %s", path);
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(errorMsg, e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private String getFullUrl(String url) {
        return this.root + url;
    }

    private UriBuilder getURIBuilder(String path, Object[] queryParams) {
        path = StringUtils.trimToEmpty((String)path);
        UriBuilder builder = UriBuilder.fromPath((String)path);
        if (queryParams != null) {
            for (int i = 0; i < queryParams.length; i += 2) {
                String param = queryParams[i].toString();
                Object value = queryParams[i + 1];
                if (value == null) continue;
                if (value instanceof Collection) {
                    Object[] values = ((Collection)value).toArray();
                    builder.queryParam(param, values);
                    continue;
                }
                builder.queryParam(param, new Object[]{value});
            }
        }
        return builder;
    }

    protected boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }

    private Optional<InputStream> getForEntity(String url, Object[] queryParams, Object ... uriVariables) {
        URI uri = this.getURIBuilder(this.getFullUrl(url), queryParams).build(uriVariables);
        try {
            return Optional.ofNullable(this.requestHandler.get(uri));
        }
        catch (RequestHandlerException rhe) {
            throw this.createClientException(rhe);
        }
    }

    private ConductorClientException createClientException(RequestHandlerException rhe) {
        ErrorResponse errorResponse;
        if (rhe.hasResponse() && (errorResponse = this.convertToType(rhe.getResponse(), ErrorResponse.class)) != null) {
            return new ConductorClientException(rhe.getStatus(), errorResponse);
        }
        return new ConductorClientException(rhe.getMessage(), rhe.getCause());
    }

    private String convertToString(InputStream inputStream) {
        try {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new ConductorClientException("Error converting response to String", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing input stream", (Throwable)e);
            }
        }
    }

    private <T> T convertToType(InputStream inputStream, Class<T> responseType) {
        try {
            String value = this.convertToString(inputStream);
            return (T)(StringUtils.isNotBlank((CharSequence)value) ? this.objectMapper.readValue(value, responseType) : null);
        }
        catch (IOException e) {
            throw new ConductorClientException("Error converting response to " + responseType, e);
        }
    }

    private <T> T convertToType(InputStream inputStream, TypeReference<T> responseType) {
        try {
            String value = this.convertToString(inputStream);
            return (T)(StringUtils.isNotBlank((CharSequence)value) ? this.objectMapper.readValue(value, responseType) : null);
        }
        catch (IOException e) {
            throw new ConductorClientException("Error converting response to " + responseType, e);
        }
    }

    class PayloadStorage
    implements ExternalPayloadStorage {
        PayloadStorage() {
        }

        public ExternalStorageLocation getLocation(ExternalPayloadStorage.Operation operation, ExternalPayloadStorage.PayloadType payloadType, String path) {
            String url;
            switch (payloadType) {
                case WORKFLOW_INPUT: 
                case WORKFLOW_OUTPUT: {
                    url = "workflow";
                    break;
                }
                case TASK_INPUT: 
                case TASK_OUTPUT: {
                    url = "tasks";
                    break;
                }
                default: {
                    throw new ConductorClientException(String.format("Invalid payload type: %s for operation: %s", payloadType, operation.toString()));
                }
            }
            return ClientBase.this.getForEntity(url + "/externalstoragelocation", new Object[]{"path", path, "operation", operation.toString(), "payloadType", payloadType.toString()}, ExternalStorageLocation.class, new Object[0]);
        }

        public void upload(String uri, InputStream payload, long payloadSize) {
            HttpURLConnection connection = null;
            try {
                URL url = new URI(uri).toURL();
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("PUT");
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(connection.getOutputStream());){
                    long count = IOUtils.copy((InputStream)payload, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.flush();
                    int responseCode = connection.getResponseCode();
                    if (Response.Status.fromStatusCode((int)responseCode).getFamily() != Response.Status.Family.SUCCESSFUL) {
                        String errorMsg = String.format("Unable to upload. Response code: %d", responseCode);
                        LOGGER.error(errorMsg);
                        throw new ConductorClientException(errorMsg);
                    }
                    LOGGER.debug("Uploaded {} bytes to uri: {}, with HTTP response code: {}", new Object[]{count, uri, responseCode});
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                String errorMsg = String.format("Invalid path specified: %s", uri);
                LOGGER.error(errorMsg, (Throwable)e);
                throw new ConductorClientException(errorMsg, e);
            }
            catch (IOException e) {
                String errorMsg = String.format("Error uploading to path: %s", uri);
                LOGGER.error(errorMsg, (Throwable)e);
                throw new ConductorClientException(errorMsg, e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                try {
                    if (payload != null) {
                        payload.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close inputstream when uploading to uri: {}", (Object)uri);
                }
            }
        }

        public InputStream download(String uri) {
            HttpURLConnection connection = null;
            try {
                URL url = new URI(uri).toURL();
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(false);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    LOGGER.debug("Download completed with HTTP response code: {}", (Object)connection.getResponseCode());
                    InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)connection.getInputStream());
                    return inputStream;
                }
                try {
                    String errorMsg = String.format("Unable to download. Response code: %d", responseCode);
                    LOGGER.error(errorMsg);
                    throw new ConductorClientException(errorMsg);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    String errorMsg = String.format("Invalid uri specified: %s", uri);
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(errorMsg, e);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Error downloading from uri: %s", uri);
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(errorMsg, e);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }
}

