/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.RequestHandler;
import com.netflix.conductor.common.metadata.events.EventHandler;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class EventClient
extends ClientBase {
    private static final TypeReference<List<EventHandler>> eventHandlerList = new TypeReference<List<EventHandler>>(){};

    public EventClient() {
        this(null);
    }

    public EventClient(RequestHandler requestHandler) {
        this(requestHandler, null);
    }

    public EventClient(RequestHandler requestHandler, ConductorClientConfiguration clientConfiguration) {
        super(requestHandler, clientConfiguration);
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.post("event", eventHandler);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.put("event", null, eventHandler, new Object[0]);
    }

    public List<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Validate.notBlank((CharSequence)event, (String)"Event cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("event/{event}", new Object[]{"activeOnly", activeOnly}, eventHandlerList, event);
    }

    public void unregisterEventHandler(String name) {
        Validate.notBlank((CharSequence)name, (String)"Event handler name cannot be blank", (Object[])new Object[0]);
        this.delete("event/{name}", name);
    }
}

