/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.tasks.Task;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TaskResult {
    private String workflowInstanceId;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Status status;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private static final Set<String> statuses = new HashSet<String>();

    public TaskResult(Task task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
    }

    public TaskResult(String workflowInstanceId, String taskId) {
        this.workflowInstanceId = workflowInstanceId;
        this.taskId = taskId;
    }

    public TaskResult() {
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Status getTaskStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public static boolean isValidStatus(String status) {
        return statuses.contains(status);
    }

    public String toString() {
        return "TaskResult [workflowInstanceId=" + this.workflowInstanceId + ", taskId=" + this.taskId + ", status=" + (Object)((Object)this.status) + "]";
    }

    static {
        for (Status status : Status.values()) {
            statuses.add(status.name());
        }
    }

    public static enum Status {
        IN_PROGRESS,
        FAILED,
        COMPLETED;

    }
}

