/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.utils;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.BlockStrategies;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.base.Predicate;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil<T> {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);
    private AtomicInteger internalNumberOfRetries = new AtomicInteger();

    public T retryOnException(Supplier<T> supplierCommand, Predicate<Throwable> throwablePredicate, Predicate<T> resultRetryPredicate, int retryCount, final String shortDescription, final String operationName) throws RuntimeException {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(Optional.ofNullable(throwablePredicate).orElse((Predicate<Throwable>)((Predicate)exception -> true))).retryIfResult(Optional.ofNullable(resultRetryPredicate).orElse(result -> false)).withWaitStrategy(WaitStrategies.join((WaitStrategy[])new WaitStrategy[]{WaitStrategies.exponentialWait((long)1000L, (long)90L, (TimeUnit)TimeUnit.SECONDS), WaitStrategies.randomWait((long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)})).withStopStrategy(StopStrategies.stopAfterAttempt((int)retryCount)).withBlockStrategy(BlockStrategies.threadSleepStrategy()).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                logger.debug("Attempt # {}, {} millis since first attempt. Operation: {}, description:{}", new Object[]{attempt.getAttemptNumber(), attempt.getDelaySinceFirstAttempt(), operationName, shortDescription});
                RetryUtil.this.internalNumberOfRetries.incrementAndGet();
            }
        }).build();
        try {
            return (T)retryer.call(supplierCommand::get);
        }
        catch (ExecutionException executionException) {
            String errorMessage = String.format("Operation '%s:%s' failed for the %d time in RetryUtil", operationName, shortDescription, this.internalNumberOfRetries.get());
            logger.debug(errorMessage);
            throw new RuntimeException(errorMessage, executionException);
        }
        catch (RetryException retryException) {
            String errorMessage = String.format("Operation '%s:%s' failed after retrying %d times, retry limit %d", operationName, shortDescription, this.internalNumberOfRetries.get(), 3);
            logger.debug(errorMessage, retryException.getLastFailedAttempt().getExceptionCause());
            throw new RuntimeException(errorMessage, retryException.getLastFailedAttempt().getExceptionCause());
        }
    }
}

