/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.common.run.Workflow;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class WorkflowSummary {
    private static final TimeZone gmt = TimeZone.getTimeZone("GMT");
    private String workflowType;
    private int version;
    private String workflowId;
    private String correlationId;
    private String startTime;
    private String updateTime;
    private String endTime;
    private Workflow.WorkflowStatus status;
    private String input;
    private String output;
    private String reasonForIncompletion;
    private long executionTime;
    private String event;
    private String failedReferenceTaskNames = "";

    public WorkflowSummary() {
    }

    public WorkflowSummary(Workflow workflow) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(gmt);
        this.workflowType = workflow.getWorkflowType();
        this.version = workflow.getVersion();
        this.workflowId = workflow.getWorkflowId();
        this.correlationId = workflow.getCorrelationId();
        if (workflow.getCreateTime() != null) {
            this.startTime = sdf.format(new Date(workflow.getCreateTime()));
        }
        if (workflow.getEndTime() > 0L) {
            this.endTime = sdf.format(new Date(workflow.getEndTime()));
        }
        if (workflow.getUpdateTime() != null) {
            this.updateTime = sdf.format(new Date(workflow.getUpdateTime()));
        }
        this.status = workflow.getStatus();
        this.input = workflow.getInput().toString();
        this.output = workflow.getOutput().toString();
        this.reasonForIncompletion = workflow.getReasonForIncompletion();
        if (workflow.getEndTime() > 0L) {
            this.executionTime = workflow.getEndTime() - workflow.getStartTime();
        }
        this.event = workflow.getEvent();
        this.failedReferenceTaskNames = workflow.getFailedReferenceTaskNames().stream().collect(Collectors.joining(","));
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Workflow.WorkflowStatus getStatus() {
        return this.status;
    }

    public String getInput() {
        return this.input;
    }

    public long getInputSize() {
        return this.input != null ? (long)this.input.length() : 0L;
    }

    public String getOutput() {
        return this.output;
    }

    public long getOutputSize() {
        return this.output != null ? (long)this.output.length() : 0L;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public void setFailedReferenceTaskNames(String failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }
}

