/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class WorkflowDef
extends Auditable {
    private String name;
    private String description;
    private int version = 1;
    private LinkedList<WorkflowTask> tasks = new LinkedList();
    private List<String> inputParameters = new LinkedList<String>();
    private Map<String, String> outputParameters = new HashMap<String, String>();
    private String failureWorkflow;
    private int schemaVersion = 1;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LinkedList<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(LinkedList<WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public Map<String, String> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Map<String, String> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            WorkflowTask task = (WorkflowTask)it.next();
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (!task.getTaskReferenceName().equals(taskReferenceName) && !task.has(taskReferenceName)) continue;
            break;
        }
        if (it.hasNext()) {
            return (WorkflowTask)it.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        Optional<WorkflowTask> found = this.all().stream().filter(wft -> wft.getTaskReferenceName().equals(taskReferenceName)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    public List<WorkflowTask> all() {
        LinkedList<WorkflowTask> all = new LinkedList<WorkflowTask>();
        for (WorkflowTask wft : this.tasks) {
            all.addAll(wft.all());
        }
        return all;
    }
}

