/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Map;

public class Task {
    private String taskType;
    private Status status;
    private Map<String, Object> inputData = new HashMap<String, Object>();
    private String referenceTaskName;
    private int retryCount;
    private int seq;
    private String correlationId;
    private int pollCount;
    private String taskDefName;
    private long scheduledTime;
    private long startTime;
    private long endTime;
    private long updateTime;
    private int startDelayInSeconds;
    private String retriedTaskId;
    private boolean retried;
    private boolean callbackFromWorker = true;
    private WorkflowTask dynamicWorkflowTask;
    private int responseTimeoutSeconds;
    private String workflowInstanceId;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Map<String, Object> outputData = new HashMap<String, Object>();

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Deprecated
    public Status getTaskStatus() {
        return this.status;
    }

    @Deprecated
    public void setTaskStatus(Status taskStatus) {
        this.status = taskStatus;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public String getReferenceTaskName() {
        return this.referenceTaskName;
    }

    public void setReferenceTaskName(String referenceTaskName) {
        this.referenceTaskName = referenceTaskName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getStartDelayInSeconds() {
        return this.startDelayInSeconds;
    }

    public void setStartDelayInSeconds(int startDelayInSeconds) {
        this.startDelayInSeconds = startDelayInSeconds;
    }

    public String getRetriedTaskId() {
        return this.retriedTaskId;
    }

    public void setRetriedTaskId(String retriedTaskId) {
        this.retriedTaskId = retriedTaskId;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getQueueWaitTime() {
        if (this.startTime > 0L && this.scheduledTime > 0L) {
            return this.startTime - this.scheduledTime - this.getCallbackAfterSeconds() * 1000L;
        }
        return 0L;
    }

    public void setQueueWaitTime(long t) {
    }

    public boolean isRetried() {
        return this.retried;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public void setPollCount(int pollCount) {
        this.pollCount = pollCount;
    }

    public boolean isCallbackFromWorker() {
        return this.callbackFromWorker;
    }

    public void setCallbackFromWorker(boolean callbackFromWorker) {
        this.callbackFromWorker = callbackFromWorker;
    }

    public String getTaskDefName() {
        if (this.taskDefName == null || "".equals(this.taskDefName)) {
            this.taskDefName = this.taskType;
        }
        return this.taskDefName;
    }

    public void setTaskDefName(String taskDefName) {
        this.taskDefName = taskDefName;
    }

    public WorkflowTask getDynamicWorkflowTask() {
        return this.dynamicWorkflowTask;
    }

    public void setDynamicWorkflowTask(WorkflowTask dynamicWorkflowTask) {
        this.dynamicWorkflowTask = dynamicWorkflowTask;
    }

    public int getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public void setResponseTimeoutSeconds(int responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public Task copy() {
        Task copy = new Task();
        copy.setCallbackAfterSeconds(this.callbackAfterSeconds);
        copy.setCallbackFromWorker(this.callbackFromWorker);
        copy.setCorrelationId(this.correlationId);
        copy.setDynamicWorkflowTask(this.dynamicWorkflowTask);
        copy.setInputData(this.inputData);
        copy.setOutputData(this.outputData);
        copy.setReferenceTaskName(this.referenceTaskName);
        copy.setStartDelayInSeconds(this.startDelayInSeconds);
        copy.setTaskDefName(this.taskDefName);
        copy.setTaskType(this.taskType);
        copy.setWorkflowInstanceId(this.workflowInstanceId);
        copy.setResponseTimeoutSeconds(this.responseTimeoutSeconds);
        copy.setStatus(this.status);
        copy.setRetryCount(this.retryCount);
        copy.setPollCount(this.pollCount);
        copy.setTaskId(this.taskId);
        copy.setReasonForIncompletion(this.reasonForIncompletion);
        copy.setWorkerId(this.workerId);
        return copy;
    }

    public String toString() {
        return "type=" + this.taskType + ", name=" + this.taskDefName + ", refName=" + this.referenceTaskName + ", taskId=" + this.getTaskId() + ", retry=" + this.retryCount + ", status=" + (Object)((Object)this.status);
    }

    public static enum Status {
        IN_PROGRESS(false, true, true),
        CANCELED(true, false, false),
        FAILED(true, false, true),
        COMPLETED(true, true, true),
        SCHEDULED(false, true, true),
        TIMED_OUT(true, false, true),
        READY_FOR_RERUN(false, true, true),
        SKIPPED(true, true, false);

        private boolean terminal;
        private boolean successful;
        private boolean retriable;

        private Status(boolean terminal, boolean successful, boolean retriable) {
            this.terminal = terminal;
            this.successful = successful;
            this.retriable = retriable;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isRetriable() {
            return this.retriable;
        }
    }
}

