/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.tasks.Task;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Workflow
extends Auditable {
    private WorkflowStatus status = WorkflowStatus.RUNNING;
    private long endTime;
    private String workflowId;
    private String parentWorkflowId;
    private String parentWorkflowTaskId;
    private List<Task> tasks = new LinkedList<Task>();
    private Map<String, Object> input = new HashMap<String, Object>();
    private Map<String, Object> output = new HashMap<String, Object>();
    private String workflowType;
    private int version;
    private String correlationId;
    private String reRunFromWorkflowId;
    private String reasonForIncompletion;
    private int schemaVersion;
    private String event;

    public WorkflowStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.getCreateTime();
    }

    public void setStartTime(long startTime) {
        this.setCreateTime(startTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getReRunFromWorkflowId() {
        return this.reRunFromWorkflowId;
    }

    public void setReRunFromWorkflowId(String reRunFromWorkflowId) {
        this.reRunFromWorkflowId = reRunFromWorkflowId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public String getParentWorkflowId() {
        return this.parentWorkflowId;
    }

    public void setParentWorkflowId(String parentWorkflowId) {
        this.parentWorkflowId = parentWorkflowId;
    }

    public String getParentWorkflowTaskId() {
        return this.parentWorkflowTaskId;
    }

    public void setParentWorkflowTaskId(String parentWorkflowTaskId) {
        this.parentWorkflowTaskId = parentWorkflowTaskId;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String toString() {
        return this.workflowType + "." + this.version + "/" + this.workflowId + "." + (Object)((Object)this.status);
    }

    public Task getTaskByRefName(String refName) {
        if (refName == null) {
            throw new RuntimeException("refName passed is null.  Check the workflow execution.  For dynamic tasks, make sure referenceTaskName is set to a not null value");
        }
        LinkedList<Task> found = new LinkedList<Task>();
        for (Task t : this.tasks) {
            if (t.getReferenceTaskName() == null) {
                throw new RuntimeException("Task " + t.getTaskDefName() + ", seq=" + t.getSeq() + " does not have reference name specified.");
            }
            if (!t.getReferenceTaskName().equals(refName)) continue;
            found.add(t);
        }
        if (found.isEmpty()) {
            return null;
        }
        return (Task)found.getLast();
    }

    public static enum WorkflowStatus {
        RUNNING(false, false),
        COMPLETED(true, true),
        FAILED(true, false),
        TIMED_OUT(true, false),
        TERMINATED(true, false),
        PAUSED(false, true);

        private boolean terminal;
        private boolean successful;

        private WorkflowStatus(boolean terminal, boolean successful) {
            this.terminal = terminal;
            this.successful = successful;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

