/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.tasks.Task;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class TaskResult {
    private String workflowInstanceId;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Status status;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private List<String> logs = new CopyOnWriteArrayList<String>();

    public TaskResult(Task task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.callbackAfterSeconds = task.getCallbackAfterSeconds();
        this.status = Status.valueOf(task.getStatus().name());
        this.workerId = task.getWorkerId();
        this.outputData = task.getOutputData();
    }

    public TaskResult() {
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public TaskResult addOutputData(String key, Object value) {
        this.outputData.put(key, value);
        return this;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public void setLogs(List<String> logs) {
        this.logs = logs;
    }

    public TaskResult log(String log) {
        this.logs.add(log);
        return this;
    }

    public String toString() {
        return "TaskResult [workflowInstanceId=" + this.workflowInstanceId + ", taskId=" + this.taskId + ", status=" + (Object)((Object)this.status) + "]";
    }

    public static TaskResult complete() {
        return TaskResult.newTaskResult(Status.COMPLETED);
    }

    public static TaskResult failed() {
        return TaskResult.newTaskResult(Status.FAILED);
    }

    public static TaskResult failed(String failureReason) {
        TaskResult result = TaskResult.newTaskResult(Status.FAILED);
        result.setReasonForIncompletion(failureReason);
        return result;
    }

    public static TaskResult inProgress() {
        return TaskResult.newTaskResult(Status.IN_PROGRESS);
    }

    public static TaskResult newTaskResult(Status status) {
        TaskResult result = new TaskResult();
        result.setStatus(status);
        return result;
    }

    public static enum Status {
        IN_PROGRESS,
        FAILED,
        COMPLETED,
        SCHEDULED;

    }
}

