/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.workflow.SubWorkflowParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkflowTask {
    private String name;
    private String taskReferenceName;
    private String description;
    private Map<String, Object> inputParameters = new HashMap<String, Object>();
    private String type = Type.SIMPLE.name();
    private String dynamicTaskNameParam;
    private String caseValueParam;
    private String caseExpression;
    private Map<String, List<WorkflowTask>> decisionCases = new LinkedHashMap<String, List<WorkflowTask>>();
    @Deprecated
    private String dynamicForkJoinTasksParam;
    private String dynamicForkTasksParam;
    private String dynamicForkTasksInputParamName;
    private List<WorkflowTask> defaultCase = new LinkedList<WorkflowTask>();
    private List<List<WorkflowTask>> forkTasks = new LinkedList<List<WorkflowTask>>();
    private int startDelay;
    private SubWorkflowParams subWorkflow;
    private List<String> joinOn = new LinkedList<String>();
    private String sink;
    private Boolean optional;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public String getType() {
        return this.type;
    }

    public void setWorkflowTaskType(Type type) {
        this.type = type.name();
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, List<WorkflowTask>> getDecisionCases() {
        return this.decisionCases;
    }

    public void setDecisionCases(Map<String, List<WorkflowTask>> decisionCases) {
        this.decisionCases = decisionCases;
    }

    public List<WorkflowTask> getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(List<WorkflowTask> defaultCase) {
        this.defaultCase = defaultCase;
    }

    public List<List<WorkflowTask>> getForkTasks() {
        return this.forkTasks;
    }

    public void setForkTasks(List<List<WorkflowTask>> forkTasks) {
        this.forkTasks = forkTasks;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public String getDynamicTaskNameParam() {
        return this.dynamicTaskNameParam;
    }

    public void setDynamicTaskNameParam(String dynamicTaskNameParam) {
        this.dynamicTaskNameParam = dynamicTaskNameParam;
    }

    public String getCaseValueParam() {
        return this.caseValueParam;
    }

    @Deprecated
    public String getDynamicForkJoinTasksParam() {
        return this.dynamicForkJoinTasksParam;
    }

    @Deprecated
    public void setDynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
    }

    public String getDynamicForkTasksParam() {
        return this.dynamicForkTasksParam;
    }

    public void setDynamicForkTasksParam(String dynamicForkTasksParam) {
        this.dynamicForkTasksParam = dynamicForkTasksParam;
    }

    public String getDynamicForkTasksInputParamName() {
        return this.dynamicForkTasksInputParamName;
    }

    public void setDynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
    }

    public void setCaseValueParam(String caseValueParam) {
        this.caseValueParam = caseValueParam;
    }

    public String getCaseExpression() {
        return this.caseExpression;
    }

    public void setCaseExpression(String caseExpression) {
        this.caseExpression = caseExpression;
    }

    public SubWorkflowParams getSubWorkflowParam() {
        return this.subWorkflow;
    }

    public void setSubWorkflowParam(SubWorkflowParams subWorkflow) {
        this.subWorkflow = subWorkflow;
    }

    public List<String> getJoinOn() {
        return this.joinOn;
    }

    public void setJoinOn(List<String> joinOn) {
        this.joinOn = joinOn;
    }

    public String getSink() {
        return this.sink;
    }

    public void setSink(String sink) {
        this.sink = sink;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    private Collection<List<WorkflowTask>> children() {
        LinkedList<List<WorkflowTask>> v1 = new LinkedList<List<WorkflowTask>>();
        Type tt = Type.USER_DEFINED;
        if (Type.isSystemTask(this.type)) {
            tt = Type.valueOf(this.type);
        }
        switch (tt) {
            case DECISION: {
                v1.addAll(this.decisionCases.values());
                v1.add(this.defaultCase);
                break;
            }
            case FORK_JOIN: {
                v1.addAll(this.forkTasks);
                break;
            }
        }
        return v1;
    }

    public List<WorkflowTask> all() {
        LinkedList<WorkflowTask> all = new LinkedList<WorkflowTask>();
        all.add(this);
        for (List<WorkflowTask> wfts : this.children()) {
            for (WorkflowTask wft : wfts) {
                all.addAll(wft.all());
            }
        }
        return all;
    }

    public WorkflowTask next(String taskReferenceName, WorkflowTask parent) {
        Type tt = Type.USER_DEFINED;
        if (Type.isSystemTask(this.type)) {
            tt = Type.valueOf(this.type);
        }
        switch (tt) {
            case DECISION: {
                for (List<WorkflowTask> wfts : this.children()) {
                    WorkflowTask task;
                    Iterator<WorkflowTask> it = wfts.iterator();
                    while (it.hasNext() && !(task = it.next()).getTaskReferenceName().equals(taskReferenceName)) {
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (!it.hasNext()) continue;
                    return it.next();
                }
                break;
            }
            case FORK_JOIN: {
                boolean found = false;
                for (List<WorkflowTask> wfts : this.children()) {
                    Iterator<WorkflowTask> it = wfts.iterator();
                    while (it.hasNext()) {
                        WorkflowTask task = it.next();
                        if (task.getTaskReferenceName().equals(taskReferenceName)) {
                            found = true;
                            break;
                        }
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask == null) continue;
                        return nextTask;
                    }
                    if (it.hasNext()) {
                        return it.next();
                    }
                    if (!found || parent == null) continue;
                    return parent.next(this.taskReferenceName, parent);
                }
                break;
            }
            case DYNAMIC: 
            case SIMPLE: {
                return null;
            }
        }
        return null;
    }

    public boolean has(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        Type tt = Type.USER_DEFINED;
        if (Type.isSystemTask(this.type)) {
            tt = Type.valueOf(this.type);
        }
        switch (tt) {
            case DECISION: 
            case FORK_JOIN: {
                for (List<WorkflowTask> childx : this.children()) {
                    for (WorkflowTask child : childx) {
                        if (!child.has(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public boolean has2(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        Type tt = Type.USER_DEFINED;
        if (Type.isSystemTask(this.type)) {
            tt = Type.valueOf(this.type);
        }
        switch (tt) {
            case DECISION: 
            case FORK_JOIN: {
                for (List<WorkflowTask> childx : this.children()) {
                    for (WorkflowTask child : childx) {
                        if (!child.getTaskReferenceName().equals(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public WorkflowTask get(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return this;
        }
        for (List<WorkflowTask> childx : this.children()) {
            for (WorkflowTask child : childx) {
                WorkflowTask found = child.get(taskReferenceName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public String toString() {
        return this.name + "/" + this.taskReferenceName;
    }

    public static enum Type {
        SIMPLE,
        DYNAMIC,
        FORK_JOIN,
        FORK_JOIN_DYNAMIC,
        DECISION,
        JOIN,
        SUB_WORKFLOW,
        EVENT,
        WAIT,
        USER_DEFINED;

        private static Set<String> systemTasks;

        public static boolean isSystemTask(String name) {
            return systemTasks.contains(name);
        }

        static {
            systemTasks = new HashSet<String>();
            systemTasks.add(SIMPLE.name());
            systemTasks.add(DYNAMIC.name());
            systemTasks.add(FORK_JOIN.name());
            systemTasks.add(FORK_JOIN_DYNAMIC.name());
            systemTasks.add(DECISION.name());
            systemTasks.add(JOIN.name());
            systemTasks.add(SUB_WORKFLOW.name());
            systemTasks.add(EVENT.name());
            systemTasks.add(WAIT.name());
        }
    }
}

