/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.github.vmg.protogen.annotations.ProtoEnum;
import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.google.protobuf.Any;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ProtoMessage
public class Task {
    @ProtoField(id=1)
    private String taskType;
    @ProtoField(id=2)
    private Status status;
    @ProtoField(id=3)
    private Map<String, Object> inputData = new HashMap<String, Object>();
    @ProtoField(id=4)
    private String referenceTaskName;
    @ProtoField(id=5)
    private int retryCount;
    @ProtoField(id=6)
    private int seq;
    @ProtoField(id=7)
    private String correlationId;
    @ProtoField(id=8)
    private int pollCount;
    @ProtoField(id=9)
    private String taskDefName;
    @ProtoField(id=10)
    private long scheduledTime;
    @ProtoField(id=11)
    private long startTime;
    @ProtoField(id=12)
    private long endTime;
    @ProtoField(id=13)
    private long updateTime;
    @ProtoField(id=14)
    private int startDelayInSeconds;
    @ProtoField(id=15)
    private String retriedTaskId;
    @ProtoField(id=16)
    private boolean retried;
    @ProtoField(id=17)
    private boolean executed;
    @ProtoField(id=18)
    private boolean callbackFromWorker = true;
    @ProtoField(id=19)
    private long responseTimeoutSeconds;
    @ProtoField(id=20)
    private String workflowInstanceId;
    @ProtoField(id=21)
    private String workflowType;
    @ProtoField(id=22)
    private String taskId;
    @ProtoField(id=23)
    private String reasonForIncompletion;
    @ProtoField(id=24)
    private long callbackAfterSeconds;
    @ProtoField(id=25)
    private String workerId;
    @ProtoField(id=26)
    private Map<String, Object> outputData = new HashMap<String, Object>();
    @ProtoField(id=27)
    private WorkflowTask workflowTask;
    @ProtoField(id=28)
    private String domain;
    @ProtoField(id=29)
    private Any inputMessage;
    @ProtoField(id=30)
    private Any outputMessage;
    @ProtoField(id=32)
    private int rateLimitPerFrequency;
    @ProtoField(id=33)
    private int rateLimitFrequencyInSeconds;
    @ProtoField(id=34)
    private String externalInputPayloadStoragePath;
    @ProtoField(id=35)
    private String externalOutputPayloadStoragePath;

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Deprecated
    public Status getTaskStatus() {
        return this.status;
    }

    @Deprecated
    public void setTaskStatus(Status taskStatus) {
        this.status = taskStatus;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public String getReferenceTaskName() {
        return this.referenceTaskName;
    }

    public void setReferenceTaskName(String referenceTaskName) {
        this.referenceTaskName = referenceTaskName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getStartDelayInSeconds() {
        return this.startDelayInSeconds;
    }

    public void setStartDelayInSeconds(int startDelayInSeconds) {
        this.startDelayInSeconds = startDelayInSeconds;
    }

    public String getRetriedTaskId() {
        return this.retriedTaskId;
    }

    public void setRetriedTaskId(String retriedTaskId) {
        this.retriedTaskId = retriedTaskId;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getQueueWaitTime() {
        if (this.startTime > 0L && this.scheduledTime > 0L) {
            return this.startTime - this.scheduledTime - this.getCallbackAfterSeconds() * 1000L;
        }
        return 0L;
    }

    public void setQueueWaitTime(long t) {
    }

    public boolean isRetried() {
        return this.retried;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public void setPollCount(int pollCount) {
        this.pollCount = pollCount;
    }

    public boolean isCallbackFromWorker() {
        return this.callbackFromWorker;
    }

    public void setCallbackFromWorker(boolean callbackFromWorker) {
        this.callbackFromWorker = callbackFromWorker;
    }

    public String getTaskDefName() {
        if (this.taskDefName == null || "".equals(this.taskDefName)) {
            this.taskDefName = this.taskType;
        }
        return this.taskDefName;
    }

    public void setTaskDefName(String taskDefName) {
        this.taskDefName = taskDefName;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public Task setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public WorkflowTask getWorkflowTask() {
        return this.workflowTask;
    }

    public void setWorkflowTask(WorkflowTask workflowTask) {
        this.workflowTask = workflowTask;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Any getInputMessage() {
        return this.inputMessage;
    }

    public void setInputMessage(Any inputMessage) {
        this.inputMessage = inputMessage;
    }

    public void setRateLimitPerFrequency(int rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public Any getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(Any outputMessage) {
        this.outputMessage = outputMessage;
    }

    public Optional<TaskDef> getTaskDefinition() {
        return Optional.ofNullable(this.getWorkflowTask()).map(WorkflowTask::getTaskDefinition);
    }

    public int getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency;
    }

    public int getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds;
    }

    public void setRateLimitFrequencyInSeconds(int rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public Task copy() {
        Task copy = new Task();
        copy.setCallbackAfterSeconds(this.callbackAfterSeconds);
        copy.setCallbackFromWorker(this.callbackFromWorker);
        copy.setCorrelationId(this.correlationId);
        copy.setInputData(this.inputData);
        copy.setOutputData(this.outputData);
        copy.setReferenceTaskName(this.referenceTaskName);
        copy.setStartDelayInSeconds(this.startDelayInSeconds);
        copy.setTaskDefName(this.taskDefName);
        copy.setTaskType(this.taskType);
        copy.setWorkflowInstanceId(this.workflowInstanceId);
        copy.setResponseTimeoutSeconds(this.responseTimeoutSeconds);
        copy.setStatus(this.status);
        copy.setRetryCount(this.retryCount);
        copy.setPollCount(this.pollCount);
        copy.setTaskId(this.taskId);
        copy.setReasonForIncompletion(this.reasonForIncompletion);
        copy.setWorkerId(this.workerId);
        copy.setWorkflowTask(this.workflowTask);
        copy.setDomain(this.domain);
        copy.setInputMessage(this.inputMessage);
        copy.setOutputMessage(this.outputMessage);
        copy.setRateLimitPerFrequency(this.rateLimitPerFrequency);
        copy.setRateLimitFrequencyInSeconds(this.rateLimitFrequencyInSeconds);
        copy.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
        copy.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        return copy;
    }

    public String toString() {
        return "Task{taskType='" + this.taskType + '\'' + ", status=" + (Object)((Object)this.status) + ", inputData=" + this.inputData + ", referenceTaskName='" + this.referenceTaskName + '\'' + ", retryCount=" + this.retryCount + ", seq=" + this.seq + ", correlationId='" + this.correlationId + '\'' + ", pollCount=" + this.pollCount + ", taskDefName='" + this.taskDefName + '\'' + ", scheduledTime=" + this.scheduledTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", updateTime=" + this.updateTime + ", startDelayInSeconds=" + this.startDelayInSeconds + ", retriedTaskId='" + this.retriedTaskId + '\'' + ", retried=" + this.retried + ", executed=" + this.executed + ", callbackFromWorker=" + this.callbackFromWorker + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", workflowInstanceId='" + this.workflowInstanceId + '\'' + ", workflowType='" + this.workflowType + '\'' + ", taskId='" + this.taskId + '\'' + ", reasonForIncompletion='" + this.reasonForIncompletion + '\'' + ", callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId='" + this.workerId + '\'' + ", outputData=" + this.outputData + ", workflowTask=" + this.workflowTask + ", domain='" + this.domain + '\'' + ", inputMessage='" + this.inputMessage + '\'' + ", outputMessage='" + this.outputMessage + '\'' + ", rateLimitPerFrequency=" + this.rateLimitPerFrequency + ", rateLimitFrequencyInSeconds=" + this.rateLimitFrequencyInSeconds + ", externalInputPayloadStoragePath='" + this.externalInputPayloadStoragePath + '\'' + ", externalOutputPayloadStoragePath='" + this.externalOutputPayloadStoragePath + '\'' + '}';
    }

    @ProtoEnum
    public static enum Status {
        IN_PROGRESS(false, true, true),
        CANCELED(true, false, false),
        FAILED(true, false, true),
        FAILED_WITH_TERMINAL_ERROR(true, false, false),
        COMPLETED(true, true, true),
        COMPLETED_WITH_ERRORS(true, true, true),
        SCHEDULED(false, true, true),
        TIMED_OUT(true, false, true),
        READY_FOR_RERUN(false, true, true),
        SKIPPED(true, true, false);

        private boolean terminal;
        private boolean successful;
        private boolean retriable;

        private Status(boolean terminal, boolean successful, boolean retriable) {
            this.terminal = terminal;
            this.successful = successful;
            this.retriable = retriable;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isRetriable() {
            return this.retriable;
        }
    }
}

