/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.netflix.conductor.common.run.Workflow;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Collectors;

@ProtoMessage
public class WorkflowSummary {
    private static final TimeZone gmt = TimeZone.getTimeZone("GMT");
    @ProtoField(id=1)
    private String workflowType;
    @ProtoField(id=2)
    private int version;
    @ProtoField(id=3)
    private String workflowId;
    @ProtoField(id=4)
    private String correlationId;
    @ProtoField(id=5)
    private String startTime;
    @ProtoField(id=6)
    private String updateTime;
    @ProtoField(id=7)
    private String endTime;
    @ProtoField(id=8)
    private Workflow.WorkflowStatus status;
    @ProtoField(id=9)
    private String input;
    @ProtoField(id=10)
    private String output;
    @ProtoField(id=11)
    private String reasonForIncompletion;
    @ProtoField(id=12)
    private long executionTime;
    @ProtoField(id=13)
    private String event;
    @ProtoField(id=14)
    private String failedReferenceTaskNames = "";

    public WorkflowSummary() {
    }

    public WorkflowSummary(Workflow workflow) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(gmt);
        this.workflowType = workflow.getWorkflowName();
        this.version = workflow.getWorkflowVersion();
        this.workflowId = workflow.getWorkflowId();
        this.correlationId = workflow.getCorrelationId();
        if (workflow.getCreateTime() != null) {
            this.startTime = sdf.format(new Date(workflow.getCreateTime()));
        }
        if (workflow.getEndTime() > 0L) {
            this.endTime = sdf.format(new Date(workflow.getEndTime()));
        }
        if (workflow.getUpdateTime() != null) {
            this.updateTime = sdf.format(new Date(workflow.getUpdateTime()));
        }
        this.status = workflow.getStatus();
        this.input = workflow.getInput().toString();
        this.output = workflow.getOutput().toString();
        this.reasonForIncompletion = workflow.getReasonForIncompletion();
        if (workflow.getEndTime() > 0L) {
            this.executionTime = workflow.getEndTime() - workflow.getStartTime();
        }
        this.event = workflow.getEvent();
        this.failedReferenceTaskNames = workflow.getFailedReferenceTaskNames().stream().collect(Collectors.joining(","));
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Workflow.WorkflowStatus getStatus() {
        return this.status;
    }

    public String getInput() {
        return this.input;
    }

    public long getInputSize() {
        return this.input != null ? (long)this.input.length() : 0L;
    }

    public String getOutput() {
        return this.output;
    }

    public long getOutputSize() {
        return this.output != null ? (long)this.output.length() : 0L;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public void setFailedReferenceTaskNames(String failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Workflow.WorkflowStatus status) {
        this.status = status;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }
}

