/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.google.common.base.MoreObjects;
import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ProtoMessage
public class WorkflowDef
extends Auditable {
    @ProtoField(id=1)
    private String name;
    @ProtoField(id=2)
    private String description;
    @ProtoField(id=3)
    private int version = 1;
    @ProtoField(id=4)
    private List<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
    @ProtoField(id=5)
    private List<String> inputParameters = new LinkedList<String>();
    @ProtoField(id=6)
    private Map<String, Object> outputParameters = new HashMap<String, Object>();
    @ProtoField(id=7)
    private String failureWorkflow;
    @ProtoField(id=8)
    private int schemaVersion = 1;
    @ProtoField(id=9)
    private boolean restartable = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        Iterator<WorkflowTask> it = this.tasks.iterator();
        while (it.hasNext()) {
            WorkflowTask task = it.next();
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (!task.getTaskReferenceName().equals(taskReferenceName) && !task.has(taskReferenceName)) continue;
            break;
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        Optional<WorkflowTask> found = this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        for (WorkflowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDef that = (WorkflowDef)o;
        return this.getVersion() == that.getVersion() && this.getSchemaVersion() == that.getSchemaVersion() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getTasks(), that.getTasks()) && Objects.equals(this.getInputParameters(), that.getInputParameters()) && Objects.equals(this.getOutputParameters(), that.getOutputParameters()) && Objects.equals(this.getFailureWorkflow(), that.getFailureWorkflow());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDescription(), this.getVersion(), this.getTasks(), this.getInputParameters(), this.getOutputParameters(), this.getFailureWorkflow(), this.getSchemaVersion());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("description", (Object)this.description).add("version", this.version).add("tasks", this.tasks).add("inputParameters", this.inputParameters).add("outputParameters", this.outputParameters).add("failureWorkflow", (Object)this.failureWorkflow).add("schemaVersion", this.schemaVersion).add("restartable", this.restartable).toString();
    }
}

