/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.github.vmg.protogen.annotations.ProtoEnum;
import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@ProtoMessage
public class Workflow
extends Auditable {
    @ProtoField(id=1)
    private WorkflowStatus status = WorkflowStatus.RUNNING;
    @ProtoField(id=2)
    private long endTime;
    @ProtoField(id=3)
    private String workflowId;
    @ProtoField(id=4)
    private String parentWorkflowId;
    @ProtoField(id=5)
    private String parentWorkflowTaskId;
    @ProtoField(id=6)
    private List<Task> tasks = new LinkedList<Task>();
    @ProtoField(id=8)
    private Map<String, Object> input = new HashMap<String, Object>();
    @ProtoField(id=9)
    private Map<String, Object> output = new HashMap<String, Object>();
    @ProtoField(id=10)
    @Deprecated
    private String workflowType;
    @ProtoField(id=11)
    @Deprecated
    private int version;
    @ProtoField(id=12)
    private String correlationId;
    @ProtoField(id=13)
    private String reRunFromWorkflowId;
    @ProtoField(id=14)
    private String reasonForIncompletion;
    @ProtoField(id=15)
    @Deprecated
    private int schemaVersion;
    @ProtoField(id=16)
    private String event;
    @ProtoField(id=17)
    private Map<String, String> taskToDomain = new HashMap<String, String>();
    @ProtoField(id=18)
    private Set<String> failedReferenceTaskNames = new HashSet<String>();
    @ProtoField(id=19)
    private WorkflowDef workflowDefinition;
    @ProtoField(id=20)
    private String externalInputPayloadStoragePath;
    @ProtoField(id=21)
    private String externalOutputPayloadStoragePath;

    public WorkflowStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.getCreateTime();
    }

    public void setStartTime(long startTime) {
        this.setCreateTime(startTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Deprecated
    public String getWorkflowType() {
        return this.workflowType;
    }

    @Deprecated
    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    @Deprecated
    public int getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(int version) {
        this.version = version;
    }

    public String getReRunFromWorkflowId() {
        return this.reRunFromWorkflowId;
    }

    public void setReRunFromWorkflowId(String reRunFromWorkflowId) {
        this.reRunFromWorkflowId = reRunFromWorkflowId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public String getParentWorkflowId() {
        return this.parentWorkflowId;
    }

    public void setParentWorkflowId(String parentWorkflowId) {
        this.parentWorkflowId = parentWorkflowId;
    }

    public String getParentWorkflowTaskId() {
        return this.parentWorkflowTaskId;
    }

    public void setParentWorkflowTaskId(String parentWorkflowTaskId) {
        this.parentWorkflowTaskId = parentWorkflowTaskId;
    }

    public int getSchemaVersion() {
        return this.getWorkflowDefinition() != null ? this.getWorkflowDefinition().getSchemaVersion() : this.schemaVersion;
    }

    @Deprecated
    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Set<String> getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public void setFailedReferenceTaskNames(Set<String> failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public WorkflowDef getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    public void setWorkflowDefinition(WorkflowDef workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public String getWorkflowName() {
        return this.getWorkflowDefinition() != null ? this.getWorkflowDefinition().getName() : this.workflowType;
    }

    public int getWorkflowVersion() {
        return this.getWorkflowDefinition() != null ? this.getWorkflowDefinition().getVersion() : this.version;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public Task getTaskByRefName(String refName) {
        if (refName == null) {
            throw new RuntimeException("refName passed is null.  Check the workflow execution.  For dynamic tasks, make sure referenceTaskName is set to a not null value");
        }
        LinkedList<Task> found = new LinkedList<Task>();
        for (Task t : this.tasks) {
            if (t.getReferenceTaskName() == null) {
                throw new RuntimeException("Task " + t.getTaskDefName() + ", seq=" + t.getSeq() + " does not have reference name specified.");
            }
            if (!t.getReferenceTaskName().equals(refName)) continue;
            found.add(t);
        }
        if (found.isEmpty()) {
            return null;
        }
        return (Task)found.getLast();
    }

    public Workflow copy() {
        Workflow copy = new Workflow();
        copy.setInput(this.input);
        copy.setOutput(this.output);
        copy.setStatus(this.status);
        copy.setWorkflowId(this.workflowId);
        copy.setParentWorkflowId(this.parentWorkflowId);
        copy.setParentWorkflowTaskId(this.parentWorkflowTaskId);
        copy.setReRunFromWorkflowId(this.reRunFromWorkflowId);
        copy.setCorrelationId(this.correlationId);
        copy.setEvent(this.event);
        copy.setReasonForIncompletion(this.reasonForIncompletion);
        copy.setWorkflowDefinition(this.workflowDefinition);
        copy.setTasks(this.tasks.stream().map(Task::copy).collect(Collectors.toList()));
        return copy;
    }

    public String toString() {
        return this.getWorkflowName() + "." + this.getWorkflowVersion() + "/" + this.workflowId + "." + (Object)((Object)this.status);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return this.getEndTime() == workflow.getEndTime() && this.getWorkflowVersion() == workflow.getWorkflowVersion() && this.getSchemaVersion() == workflow.getSchemaVersion() && this.getStatus() == workflow.getStatus() && Objects.equals(this.getWorkflowId(), workflow.getWorkflowId()) && Objects.equals(this.getParentWorkflowId(), workflow.getParentWorkflowId()) && Objects.equals(this.getParentWorkflowTaskId(), workflow.getParentWorkflowTaskId()) && Objects.equals(this.getTasks(), workflow.getTasks()) && Objects.equals(this.getInput(), workflow.getInput()) && Objects.equals(this.getOutput(), workflow.getOutput()) && Objects.equals(this.getWorkflowName(), workflow.getWorkflowName()) && Objects.equals(this.getCorrelationId(), workflow.getCorrelationId()) && Objects.equals(this.getReRunFromWorkflowId(), workflow.getReRunFromWorkflowId()) && Objects.equals(this.getReasonForIncompletion(), workflow.getReasonForIncompletion()) && Objects.equals(this.getEvent(), workflow.getEvent()) && Objects.equals(this.getTaskToDomain(), workflow.getTaskToDomain()) && Objects.equals(this.getFailedReferenceTaskNames(), workflow.getFailedReferenceTaskNames()) && Objects.equals(this.getExternalInputPayloadStoragePath(), workflow.getExternalInputPayloadStoragePath()) && Objects.equals(this.getExternalOutputPayloadStoragePath(), workflow.getExternalOutputPayloadStoragePath()) && Objects.equals(this.getWorkflowDefinition(), workflow.getWorkflowDefinition());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getEndTime(), this.getWorkflowId(), this.getParentWorkflowId(), this.getParentWorkflowTaskId(), this.getTasks(), this.getInput(), this.getOutput(), this.getWorkflowName(), this.getWorkflowVersion(), this.getCorrelationId(), this.getReRunFromWorkflowId(), this.getReasonForIncompletion(), this.getSchemaVersion(), this.getEvent(), this.getTaskToDomain(), this.getFailedReferenceTaskNames(), this.getWorkflowDefinition(), this.getExternalInputPayloadStoragePath(), this.getExternalOutputPayloadStoragePath()});
    }

    @ProtoEnum
    public static enum WorkflowStatus {
        RUNNING(false, false),
        COMPLETED(true, true),
        FAILED(true, false),
        TIMED_OUT(true, false),
        TERMINATED(true, false),
        PAUSED(false, true);

        private boolean terminal;
        private boolean successful;

        private WorkflowStatus(boolean terminal, boolean successful) {
            this.terminal = terminal;
            this.successful = successful;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

