/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.github.vmg.protogen.annotations.ProtoEnum;

@ProtoEnum
public enum TaskType {
    SIMPLE(true),
    DYNAMIC(true),
    FORK_JOIN(true),
    FORK_JOIN_DYNAMIC(true),
    DECISION(true),
    JOIN(true),
    SUB_WORKFLOW(true),
    EVENT(true),
    WAIT(true),
    USER_DEFINED(false),
    HTTP(true),
    LAMBDA(true),
    EXCLUSIVE_JOIN(true);

    public static final String TASK_TYPE_DECISION = "DECISION";
    public static final String TASK_TYPE_DYNAMIC = "DYNAMIC";
    public static final String TASK_TYPE_JOIN = "JOIN";
    public static final String TASK_TYPE_FORK_JOIN_DYNAMIC = "FORK_JOIN_DYNAMIC";
    public static final String TASK_TYPE_EVENT = "EVENT";
    public static final String TASK_TYPE_WAIT = "WAIT";
    public static final String TASK_TYPE_SUB_WORKFLOW = "SUB_WORKFLOW";
    public static final String TASK_TYPE_FORK_JOIN = "FORK_JOIN";
    public static final String TASK_TYPE_USER_DEFINED = "USER_DEFINED";
    public static final String TASK_TYPE_SIMPLE = "SIMPLE";
    public static final String TASK_TYPE_HTTP = "HTTP";
    public static final String TASK_TYPE_LAMBDA = "LAMBDA";
    public static final String TASK_TYPE_EXLCUSIVE_JOIN = "EXCLUSIVE_JOIN";
    private boolean isSystemTask;

    private TaskType(boolean isSystemTask) {
        this.isSystemTask = isSystemTask;
    }

    public static boolean isSystemTask(String name) {
        try {
            TaskType taskType = TaskType.valueOf(name);
            return taskType.isSystemTask;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

