/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.common.utils.ConstraintParamUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.mutable.MutableBoolean;

@Documented
@Constraint(validatedBy={TaskReferenceNameUniqueValidator.class})
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TaskReferenceNameUniqueConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class TaskReferenceNameUniqueValidator
    implements ConstraintValidator<TaskReferenceNameUniqueConstraint, WorkflowDef> {
        public void initialize(TaskReferenceNameUniqueConstraint constraintAnnotation) {
        }

        public boolean isValid(WorkflowDef workflowDef, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            boolean valid = true;
            HashMap<String, Integer> taskReferenceMap = new HashMap<String, Integer>();
            for (WorkflowTask workflowTask : workflowDef.getTasks()) {
                if (taskReferenceMap.containsKey(workflowTask.getTaskReferenceName())) {
                    String message = String.format("taskReferenceName: %s should be unique across tasks for a given workflowDefinition: %s", workflowTask.getTaskReferenceName(), workflowDef.getName());
                    context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                    valid = false;
                    continue;
                }
                taskReferenceMap.put(workflowTask.getTaskReferenceName(), 1);
            }
            return valid & this.verifyTaskInputParameters(context, workflowDef);
        }

        private boolean verifyTaskInputParameters(ConstraintValidatorContext context, WorkflowDef workflow) {
            MutableBoolean valid = new MutableBoolean();
            valid.setValue(true);
            if (workflow.getTasks() == null) {
                return valid.getValue();
            }
            workflow.getTasks().stream().filter(workflowTask -> workflowTask.getInputParameters() != null).forEach(workflowTask -> {
                List<String> errors = ConstraintParamUtil.validateInputParam(workflowTask.getInputParameters(), workflowTask.getName(), workflow);
                errors.forEach(message -> context.buildConstraintViolationWithTemplate(message).addConstraintViolation());
                if (errors.size() > 0) {
                    valid.setValue(false);
                }
            });
            return valid.getValue();
        }
    }
}

