/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.github.vmg.protogen.annotations.ProtoEnum;
import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.google.protobuf.Any;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@ProtoMessage
public class TaskResult {
    @ProtoField(id=1)
    private String workflowInstanceId;
    @ProtoField(id=2)
    private String taskId;
    @ProtoField(id=3)
    private String reasonForIncompletion;
    @ProtoField(id=4)
    private long callbackAfterSeconds;
    @ProtoField(id=5)
    private String workerId;
    @ProtoField(id=6)
    private Status status;
    @ProtoField(id=7)
    private Map<String, Object> outputData = new HashMap<String, Object>();
    @ProtoField(id=8)
    private Any outputMessage;
    private List<TaskExecLog> logs = new CopyOnWriteArrayList<TaskExecLog>();
    private String externalOutputPayloadStoragePath;

    public TaskResult(Task task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.callbackAfterSeconds = task.getCallbackAfterSeconds();
        this.status = Status.valueOf(task.getStatus().name());
        this.workerId = task.getWorkerId();
        this.outputData = task.getOutputData();
        this.externalOutputPayloadStoragePath = task.getExternalOutputPayloadStoragePath();
    }

    public TaskResult() {
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public TaskResult addOutputData(String key, Object value) {
        this.outputData.put(key, value);
        return this;
    }

    public Any getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(Any outputMessage) {
        this.outputMessage = outputMessage;
    }

    public List<TaskExecLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<TaskExecLog> logs) {
        this.logs = logs;
    }

    public TaskResult log(String log) {
        this.logs.add(new TaskExecLog(log));
        return this;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public String toString() {
        return "TaskResult{workflowInstanceId='" + this.workflowInstanceId + '\'' + ", taskId='" + this.taskId + '\'' + ", reasonForIncompletion='" + this.reasonForIncompletion + '\'' + ", callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId='" + this.workerId + '\'' + ", status=" + (Object)((Object)this.status) + ", outputData=" + this.outputData + ", outputMessage=" + this.outputMessage + ", logs=" + this.logs + ", externalOutputPayloadStoragePath='" + this.externalOutputPayloadStoragePath + '\'' + '}';
    }

    public static TaskResult complete() {
        return TaskResult.newTaskResult(Status.COMPLETED);
    }

    public static TaskResult failed() {
        return TaskResult.newTaskResult(Status.FAILED);
    }

    public static TaskResult failed(String failureReason) {
        TaskResult result = TaskResult.newTaskResult(Status.FAILED);
        result.setReasonForIncompletion(failureReason);
        return result;
    }

    public static TaskResult inProgress() {
        return TaskResult.newTaskResult(Status.IN_PROGRESS);
    }

    public static TaskResult newTaskResult(Status status) {
        TaskResult result = new TaskResult();
        result.setStatus(status);
        return result;
    }

    @ProtoEnum
    public static enum Status {
        IN_PROGRESS,
        FAILED,
        FAILED_WITH_TERMINAL_ERROR,
        COMPLETED,
        SCHEDULED;

    }
}

