/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy={RetryLogicValidator.class})
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RetryLogicConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class RetryLogicValidator
    implements ConstraintValidator<RetryLogicConstraint, TaskDef> {
        public void initialize(RetryLogicConstraint constraintAnnotation) {
        }

        public boolean isValid(TaskDef taskDef, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            boolean valid = true;
            if (taskDef.getRetryLogic() == TaskDef.RetryLogic.UNSPECIFIED && taskDef.isRetryDelaySet()) {
                valid = false;
                String message = String.format("TaskDef: %s retryPolicy can't be UNSPECIFIED as retryDelay is set", taskDef.getName());
                context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
            }
            return valid;
        }
    }
}

