/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import com.netflix.conductor.common.utils.ConstraintParamUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

@Documented
@Constraint(validatedBy={TaskInputParamValidator.class})
@Target(value={ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TaskInputParamConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class TaskInputParamValidator
    implements ConstraintValidator<TaskInputParamConstraint, Map<String, Object>> {
        public void initialize(TaskInputParamConstraint constraintAnnotation) {
        }

        public boolean isValid(Map<String, Object> inputParameters, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (inputParameters == null) {
                return true;
            }
            MutableBoolean valid = new MutableBoolean();
            valid.setValue(true);
            inputParameters.forEach((key, inputParam) -> {
                String paramPath = Objects.toString(inputParam, "");
                if (inputParam != null && StringUtils.isNotBlank((CharSequence)paramPath)) {
                    String[] paramPathComponents = ConstraintParamUtil.extractParamPathComponents(inputParam.toString());
                    if (paramPathComponents != null) {
                        for (String param : paramPathComponents) {
                            if (!StringUtils.containsWhitespace((CharSequence)param)) continue;
                            valid.setValue(false);
                            String message = String.format("key: %s input parameter value: %s is not valid", key, paramPath);
                            context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                        }
                    }
                } else {
                    valid.setValue(false);
                    String message = String.format("key: %s input parameter value: is null or empty", key);
                    context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                }
            });
            return valid.getValue();
        }
    }
}

