/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.utils;

import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.common.utils.EnvUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConstraintParamUtil {
    public static List<String> validateInputParam(Map<String, Object> input, String taskName, WorkflowDef workflow) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Map.Entry<String, Object> e : input.entrySet()) {
            Object value = e.getValue();
            if (value instanceof String) {
                errorList.addAll(ConstraintParamUtil.extractParamPathComponentsFromString(e.getKey(), value.toString(), taskName, workflow));
                continue;
            }
            if (value instanceof Map) {
                errorList.addAll(ConstraintParamUtil.validateInputParam((Map)value, taskName, workflow));
                continue;
            }
            if (value instanceof List) {
                errorList.addAll(ConstraintParamUtil.extractListInputParam(e.getKey(), (List)value, taskName, workflow));
                continue;
            }
            e.setValue(value);
        }
        return errorList;
    }

    private static List<String> extractListInputParam(String key, List<?> values, String taskName, WorkflowDef workflow) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Object listVal : values) {
            if (listVal instanceof String) {
                errorList.addAll(ConstraintParamUtil.extractParamPathComponentsFromString(key, listVal.toString(), taskName, workflow));
                continue;
            }
            if (listVal instanceof Map) {
                errorList.addAll(ConstraintParamUtil.validateInputParam((Map)listVal, taskName, workflow));
                continue;
            }
            if (!(listVal instanceof List)) continue;
            errorList.addAll(ConstraintParamUtil.extractListInputParam(key, (List)listVal, taskName, workflow));
        }
        return errorList;
    }

    private static List<String> extractParamPathComponentsFromString(String key, String value, String taskName, WorkflowDef workflow) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            String message = String.format("key: %s input parameter value: is null or empty", key);
            errorList.add(message);
            return errorList;
        }
        String[] values = value.split("(?=\\$\\{)|(?<=\\})");
        for (int i = 0; i < values.length; ++i) {
            WorkflowTask task;
            if (!values[i].startsWith("${") || !values[i].endsWith("}")) continue;
            String paramPath = values[i].substring(2, values[i].length() - 1);
            if (StringUtils.containsWhitespace((CharSequence)paramPath)) {
                String message = String.format("key: %s input parameter value: %s is not valid", key, paramPath);
                errorList.add(message);
                continue;
            }
            if (EnvUtils.isEnvironmentVariable(paramPath)) {
                String sysValue = EnvUtils.getSystemParametersValue(paramPath, "");
                if (sysValue != null) continue;
                String errorMessage = String.format("environment variable: %s for given task: %s input value: %s of input parameter: %s is not valid", paramPath, taskName, key, value);
                errorList.add(errorMessage);
                continue;
            }
            String[] components = paramPath.split("\\.");
            if ("workflow".equals(components[0]) || (task = workflow.getTaskByRefName(components[0])) != null) continue;
            String message = String.format("taskReferenceName: %s for given task: %s input value: %s of input parameter: %s is not defined in workflow definition.", components[0], taskName, key, value);
            errorList.add(message);
        }
        return errorList;
    }
}

