/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import com.google.common.base.Strings;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy={NoSemiColonValidator.class})
@Target(value={ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface NoSemiColonConstraint {
    public String message() default "String: cannot contain the following set of characters: ':'";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class NoSemiColonValidator
    implements ConstraintValidator<NoSemiColonConstraint, String> {
        public void initialize(NoSemiColonConstraint constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            boolean valid = true;
            if (!Strings.isNullOrEmpty((String)value) && value.contains(":")) {
                valid = false;
            }
            return valid;
        }
    }
}

