/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.annotations.protogen.ProtoEnum;
import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import com.netflix.conductor.common.constraints.NoSemiColonConstraint;
import com.netflix.conductor.common.constraints.OwnerEmailMandatoryConstraint;
import com.netflix.conductor.common.constraints.TaskReferenceNameUniqueConstraint;
import com.netflix.conductor.common.metadata.BaseDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@ProtoMessage
@TaskReferenceNameUniqueConstraint
public class WorkflowDef
extends BaseDef {
    @NotEmpty(message="WorkflowDef name cannot be null or empty")
    @ProtoField(id=1)
    @NoSemiColonConstraint(message="Workflow name cannot contain the following set of characters: ':'")
    private @NotEmpty(message="WorkflowDef name cannot be null or empty") String name;
    @ProtoField(id=2)
    private String description;
    @ProtoField(id=3)
    private int version = 1;
    @ProtoField(id=4)
    @NotNull
    @NotEmpty(message="WorkflowTask list cannot be empty")
    private @NotNull @NotEmpty(message="WorkflowTask list cannot be empty") List<@Valid WorkflowTask> tasks = new LinkedList<WorkflowTask>();
    @ProtoField(id=5)
    private List<String> inputParameters = new LinkedList<String>();
    @ProtoField(id=6)
    private Map<String, Object> outputParameters = new HashMap<String, Object>();
    @ProtoField(id=7)
    private String failureWorkflow;
    @ProtoField(id=8)
    @Min(value=2L, message="workflowDef schemaVersion: {value} is only supported")
    @Max(value=2L, message="workflowDef schemaVersion: {value} is only supported")
    private @Min(value=2L, message="workflowDef schemaVersion: {value} is only supported") @Max(value=2L, message="workflowDef schemaVersion: {value} is only supported") int schemaVersion = 2;
    @ProtoField(id=9)
    private boolean restartable = true;
    @ProtoField(id=10)
    private boolean workflowStatusListenerEnabled = false;
    @ProtoField(id=11)
    @OwnerEmailMandatoryConstraint
    @Email(message="ownerEmail should be valid email address")
    private @Email(message="ownerEmail should be valid email address") String ownerEmail;
    @ProtoField(id=12)
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.ALERT_ONLY;
    @ProtoField(id=13)
    @NotNull
    private long timeoutSeconds;
    @ProtoField(id=14)
    private Map<String, Object> variables = new HashMap<String, Object>();
    @ProtoField(id=15)
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<@Valid WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean isWorkflowStatusListenerEnabled() {
        return this.workflowStatusListenerEnabled;
    }

    public void setWorkflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public boolean containsType(String taskType) {
        return this.collectTasks().stream().anyMatch(t -> t.getType().equals(taskType));
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        WorkflowTask task;
        WorkflowTask workflowTask = this.getTaskByRefName(taskReferenceName);
        if (workflowTask != null && TaskType.TERMINATE.name().equals(workflowTask.getType())) {
            return null;
        }
        Iterator<WorkflowTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (TaskType.DO_WHILE.name().equals(task.getType()) && !task.getTaskReferenceName().equals(taskReferenceName) && task.has(taskReferenceName)) {
                return null;
            }
            if (!task.has(taskReferenceName)) continue;
            break;
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        return this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst().orElse(null);
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        for (WorkflowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDef that = (WorkflowDef)o;
        return this.getVersion() == that.getVersion() && this.getSchemaVersion() == that.getSchemaVersion() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getTasks(), that.getTasks()) && Objects.equals(this.getInputParameters(), that.getInputParameters()) && Objects.equals(this.getOutputParameters(), that.getOutputParameters()) && Objects.equals(this.getFailureWorkflow(), that.getFailureWorkflow()) && Objects.equals(this.getOwnerEmail(), that.getOwnerEmail()) && Objects.equals(this.getTimeoutSeconds(), that.getTimeoutSeconds());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDescription(), this.getVersion(), this.getTasks(), this.getInputParameters(), this.getOutputParameters(), this.getFailureWorkflow(), this.getSchemaVersion(), this.getOwnerEmail(), this.getTimeoutSeconds());
    }

    public String toString() {
        return "WorkflowDef{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", version=" + this.version + ", tasks=" + this.tasks + ", inputParameters=" + this.inputParameters + ", outputParameters=" + this.outputParameters + ", failureWorkflow='" + this.failureWorkflow + '\'' + ", schemaVersion=" + this.schemaVersion + ", restartable=" + this.restartable + ", workflowStatusListenerEnabled=" + this.workflowStatusListenerEnabled + ", timeoutSeconds=" + this.timeoutSeconds + '}';
    }

    @ProtoEnum
    public static enum TimeoutPolicy {
        TIME_OUT_WF,
        ALERT_ONLY;

    }
}

