/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import com.netflix.conductor.common.constraints.NoSemiColonConstraint;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;

@ProtoMessage
public class WorkflowDefSummary
implements Comparable<WorkflowDefSummary> {
    @NotEmpty(message="WorkflowDef name cannot be null or empty")
    @ProtoField(id=1)
    @NoSemiColonConstraint(message="Workflow name cannot contain the following set of characters: ':'")
    private @NotEmpty(message="WorkflowDef name cannot be null or empty") String name;
    @ProtoField(id=2)
    private int version = 1;
    @ProtoField(id=3)
    private Long createTime;

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDefSummary that = (WorkflowDefSummary)o;
        return this.getVersion() == that.getVersion() && Objects.equals(this.getName(), that.getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getVersion());
    }

    public String toString() {
        return "WorkflowDef{name='" + this.name + ", version=" + this.version + "}";
    }

    @Override
    public int compareTo(WorkflowDefSummary o) {
        int res = this.name.compareTo(o.name);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.version, o.version);
        return res;
    }
}

