/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Documented
@Constraint(validatedBy={WorkflowTaskValidValidator.class})
@Target(value={ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OwnerEmailMandatoryConstraint {
    public String message() default "ownerEmail cannot be empty";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class WorkflowTaskValidValidator
    implements ConstraintValidator<OwnerEmailMandatoryConstraint, String> {
        private static boolean ownerEmailMandatory = true;

        public void initialize(OwnerEmailMandatoryConstraint constraintAnnotation) {
        }

        public boolean isValid(String ownerEmail, ConstraintValidatorContext context) {
            return !ownerEmailMandatory || !StringUtils.isEmpty((CharSequence)ownerEmail);
        }

        public static void setOwnerEmailMandatory(boolean ownerEmailMandatory) {
            WorkflowTaskValidValidator.ownerEmailMandatory = ownerEmailMandatory;
        }
    }
}

