/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.es6.index.query.parser;

import com.netflix.conductor.dao.es6.index.query.parser.FilterProvider;
import com.netflix.conductor.dao.es6.index.query.parser.GroupedExpression;
import com.netflix.conductor.dao.es6.index.query.parser.NameValue;
import com.netflix.conductor.elasticsearch.query.parser.AbstractNode;
import com.netflix.conductor.elasticsearch.query.parser.BooleanOp;
import com.netflix.conductor.elasticsearch.query.parser.ParserException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class Expression
extends AbstractNode
implements FilterProvider {
    private NameValue nameVal;
    private GroupedExpression ge;
    private BooleanOp op;
    private Expression rhs;

    public Expression(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        byte[] peeked = this.peek(1);
        if (peeked[0] == 40) {
            this.ge = new GroupedExpression(this.is);
        } else {
            this.nameVal = new NameValue(this.is);
        }
        peeked = this.peek(3);
        if (this.isBoolOpr(peeked)) {
            this.op = new BooleanOp(this.is);
            this.rhs = new Expression(this.is);
        }
    }

    public boolean isBinaryExpr() {
        return this.op != null;
    }

    public BooleanOp getOperator() {
        return this.op;
    }

    public Expression getRightHandSide() {
        return this.rhs;
    }

    public boolean isNameValue() {
        return this.nameVal != null;
    }

    public NameValue getNameValue() {
        return this.nameVal;
    }

    public GroupedExpression getGroupedExpression() {
        return this.ge;
    }

    @Override
    public QueryBuilder getFilterBuilder() {
        QueryBuilder lhs = null;
        lhs = this.nameVal != null ? this.nameVal.getFilterBuilder() : this.ge.getFilterBuilder();
        if (this.isBinaryExpr()) {
            QueryBuilder rhsFilter = this.rhs.getFilterBuilder();
            if (this.op.isAnd()) {
                return QueryBuilders.boolQuery().must(lhs).must(rhsFilter);
            }
            return QueryBuilders.boolQuery().should(lhs).should(rhsFilter);
        }
        return lhs;
    }

    public String toString() {
        if (this.isBinaryExpr()) {
            return "" + (this.nameVal == null ? this.ge : this.nameVal) + this.op + this.rhs;
        }
        return "" + (this.nameVal == null ? this.ge : this.nameVal);
    }

    public static Expression fromString(String value) throws ParserException {
        return new Expression(new BufferedInputStream(new ByteArrayInputStream(value.getBytes())));
    }
}

