/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;

public class ElasticSearchRestClientProvider
implements Provider<RestClient> {
    private final ElasticSearchConfiguration configuration;

    @Inject
    public ElasticSearchRestClientProvider(ElasticSearchConfiguration configuration) {
        this.configuration = configuration;
    }

    public RestClient get() {
        return RestClient.builder((HttpHost[])this.convertToHttpHosts(this.configuration.getURIs())).build();
    }

    private HttpHost[] convertToHttpHosts(List<URI> hosts) {
        List<HttpHost> list = hosts.stream().map(host -> new HttpHost(host.getHost(), host.getPort(), host.getScheme())).collect(Collectors.toList());
        return list.toArray(new HttpHost[list.size()]);
    }
}

