/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.netflix.conductor.service.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EmbeddedElasticSearch
extends Lifecycle {
    public static final Logger logger = LoggerFactory.getLogger(EmbeddedElasticSearch.class);

    default public void cleanDataDir(String path) {
        File dataDir = new File(path);
        try {
            logger.info("Deleting contents of data dir {}", (Object)path);
            if (dataDir.exists()) {
                FileUtils.cleanDirectory((File)dataDir);
            }
        }
        catch (IOException e) {
            logger.error(String.format("Failed to delete ES data dir: %s", dataDir.getAbsolutePath()), (Throwable)e);
        }
    }

    default public File createDataDir(String dataDirLoc) throws IOException {
        Path dataDirPath = FileSystems.getDefault().getPath(dataDirLoc, new String[0]);
        Files.createDirectories(dataDirPath, new FileAttribute[0]);
        return dataDirPath.toFile();
    }

    default public File setupDataDir(String path) throws IOException {
        this.cleanDataDir(path);
        return this.createDataDir(path);
    }
}

