/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.google.common.base.Strings;
import com.netflix.conductor.core.config.Configuration;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface ElasticSearchConfiguration
extends Configuration {
    public static final String ELASTICSEARCH_PROPERTY_NAME = "workflow.elasticsearch.instanceType";
    public static final ElasticSearchInstanceType ELASTICSEARCH_INSTANCE_TYPE_DEFAULT_VALUE = ElasticSearchInstanceType.MEMORY;
    public static final String ELASTIC_SEARCH_URL_PROPERTY_NAME = "workflow.elasticsearch.url";
    public static final String ELASTIC_SEARCH_URL_DEFAULT_VALUE = "localhost:9300";
    public static final String ELASTIC_SEARCH_HEALTH_COLOR_PROPERTY_NAME = "workflow.elasticsearch.cluster.health.color";
    public static final String ELASTIC_SEARCH_HEALTH_COLOR_DEFAULT_VALUE = "green";
    public static final String ELASTIC_SEARCH_INDEX_NAME_PROPERTY_NAME = "workflow.elasticsearch.index.name";
    public static final String ELASTIC_SEARCH_INDEX_NAME_DEFAULT_VALUE = "conductor";
    public static final String TASK_LOG_INDEX_NAME_PROPERTY_NAME = "workflow.elasticsearch.tasklog.index.name";
    public static final String TASK_LOG_INDEX_NAME_DEFAULT_VALUE = "task_log";
    public static final String EMBEDDED_DATA_PATH_PROPERTY_NAME = "workflow.elasticsearch.embedded.data.path";
    public static final String EMBEDDED_DATA_PATH_DEFAULT_VALUE = "path.data";
    public static final String EMBEDDED_HOME_PATH_PROPERTY_NAME = "workflow.elasticsearch.embedded.data.home";
    public static final String EMBEDDED_HOME_PATH_DEFAULT_VALUE = "path.home";
    public static final String EMBEDDED_PORT_PROPERTY_NAME = "workflow.elasticsearch.embedded.port";
    public static final int EMBEDDED_PORT_DEFAULT_VALUE = 9200;
    public static final String EMBEDDED_CLUSTER_NAME_PROPERTY_NAME = "workflow.elasticsearch.embedded.cluster.name";
    public static final String EMBEDDED_CLUSTER_NAME_DEFAULT_VALUE = "elasticsearch_test";
    public static final String EMBEDDED_HOST_PROPERTY_NAME = "workflow.elasticsearch.embedded.host";
    public static final String EMBEDDED_HOST_DEFAULT_VALUE = "127.0.0.1";
    public static final String EMBEDDED_SETTINGS_FILE_PROPERTY_NAME = "workflow.elasticsearch.embedded.settings.file";
    public static final String EMBEDDED_SETTINGS_FILE_DEFAULT_VALUE = "embedded-es.yml";
    public static final String ELASTIC_SEARCH_ARCHIVE_SEARCH_BATCH_SIZE_PROPERTY_NAME = "workflow.elasticsearch.archive.search.batchSize";
    public static final int ELASTIC_SEARCH_ARCHIVE_SEARCH_BATCH_SIZE_DEFAULT_VALUE = 5000;
    public static final String ELASTIC_SEARCH_INDEX_BATCH_SIZE_PROPERTY_NAME = "workflow.elasticsearch.index.batchSize";
    public static final int ELASTIC_SEARCH_INDEX_BATCH_SIZE_DEFAULT_VALUE = 1;
    public static final String ELASTIC_SEARCH_ASYNC_DAO_WORKER_QUEUE_SIZE = "workflow.elasticsearch.async.dao.worker.queue.size";
    public static final int DEFAULT_ASYNC_WORKER_QUEUE_SIZE = 100;
    public static final String ELASTIC_SEARCH_ASYNC_DAO_MAX_POOL_SIZE = "workflow.elasticsearch.async.dao.max.pool.size";
    public static final int DEFAULT_ASYNC_MAX_POOL_SIZE = 12;
    public static final String ELASTIC_SEARCH_ASYNC_BUFFER_FLUSH_TIMEOUT_PROPERTY_NAME = "workflow.elasticsearch.async.buffer.flush.timeout.seconds";
    public static final int ELASTIC_SEARCH_ASYNC_BUFFER_FLUSH_TIMEOUT_DEFAULT_VALUE = 10;
    public static final String ELASTIC_SEARCH_INDEX_SHARD_COUNT_PROPERTY_NAME = "workflow.elasticsearch.index.shard.count";
    public static final int ELASTIC_SEARCH_INDEX_SHARD_COUNT_DEFAULT_VALUE = 5;
    public static final String ELASTIC_SEARCH_INDEX_REPLICAS_COUNT_PROPERTY_NAME = "workflow.elasticsearch.index.replicas.count";
    public static final int ELASTIC_SEARCH_INDEX_REPLICAS_COUNT_DEFAULT_VALUE = 1;
    public static final String ELASTIC_SEARCH_TASK_LOG_RESULT_LIMIT = "tasklog.elasticsearch.query.size";
    public static final int ELASTIC_SEARCH_TASK_LOG_RESULT_LIMIT_DEFAULT_VALUE = 10;

    default public String getURL() {
        return this.getProperty(ELASTIC_SEARCH_URL_PROPERTY_NAME, ELASTIC_SEARCH_URL_DEFAULT_VALUE);
    }

    default public List<URI> getURIs() {
        String clusterAddress = this.getURL();
        String[] hosts = clusterAddress.split(",");
        return Arrays.stream(hosts).map(host -> host.startsWith("http://") || host.startsWith("https://") || host.startsWith("tcp://") ? URI.create(host) : URI.create("tcp://" + host)).collect(Collectors.toList());
    }

    default public String getIndexName() {
        return this.getProperty(ELASTIC_SEARCH_INDEX_NAME_PROPERTY_NAME, ELASTIC_SEARCH_INDEX_NAME_DEFAULT_VALUE);
    }

    default public String getTasklogIndexName() {
        return this.getProperty(TASK_LOG_INDEX_NAME_PROPERTY_NAME, TASK_LOG_INDEX_NAME_DEFAULT_VALUE);
    }

    default public String getClusterHealthColor() {
        return this.getProperty(ELASTIC_SEARCH_HEALTH_COLOR_PROPERTY_NAME, ELASTIC_SEARCH_HEALTH_COLOR_DEFAULT_VALUE);
    }

    default public String getEmbeddedDataPath() {
        return this.getProperty(EMBEDDED_DATA_PATH_PROPERTY_NAME, EMBEDDED_DATA_PATH_DEFAULT_VALUE);
    }

    default public String getEmbeddedHomePath() {
        return this.getProperty(EMBEDDED_HOME_PATH_PROPERTY_NAME, EMBEDDED_HOME_PATH_DEFAULT_VALUE);
    }

    default public int getEmbeddedPort() {
        return this.getIntProperty(EMBEDDED_PORT_PROPERTY_NAME, 9200);
    }

    default public String getEmbeddedClusterName() {
        return this.getProperty(EMBEDDED_CLUSTER_NAME_PROPERTY_NAME, EMBEDDED_CLUSTER_NAME_DEFAULT_VALUE);
    }

    default public String getEmbeddedHost() {
        return this.getProperty(EMBEDDED_HOST_PROPERTY_NAME, EMBEDDED_HOST_DEFAULT_VALUE);
    }

    default public String getEmbeddedSettingsFile() {
        return this.getProperty(EMBEDDED_SETTINGS_FILE_PROPERTY_NAME, EMBEDDED_SETTINGS_FILE_DEFAULT_VALUE);
    }

    default public ElasticSearchInstanceType getElasticSearchInstanceType() {
        ElasticSearchInstanceType elasticSearchInstanceType = ELASTICSEARCH_INSTANCE_TYPE_DEFAULT_VALUE;
        String instanceTypeConfig = this.getProperty(ELASTICSEARCH_PROPERTY_NAME, "");
        if (!Strings.isNullOrEmpty((String)instanceTypeConfig)) {
            elasticSearchInstanceType = ElasticSearchInstanceType.valueOf(instanceTypeConfig.toUpperCase());
        }
        return elasticSearchInstanceType;
    }

    default public int getArchiveSearchBatchSize() {
        return this.getIntProperty(ELASTIC_SEARCH_ARCHIVE_SEARCH_BATCH_SIZE_PROPERTY_NAME, 5000);
    }

    default public int getIndexBatchSize() {
        return this.getIntProperty(ELASTIC_SEARCH_INDEX_BATCH_SIZE_PROPERTY_NAME, 1);
    }

    default public int getAsyncWorkerQueueSize() {
        return this.getIntProperty(ELASTIC_SEARCH_ASYNC_DAO_WORKER_QUEUE_SIZE, 100);
    }

    default public int getAsyncMaxPoolSize() {
        return this.getIntProperty(ELASTIC_SEARCH_ASYNC_DAO_MAX_POOL_SIZE, 12);
    }

    default public int getAsyncBufferFlushTimeout() {
        return this.getIntProperty(ELASTIC_SEARCH_ASYNC_BUFFER_FLUSH_TIMEOUT_PROPERTY_NAME, 10);
    }

    default public int getElasticSearchIndexShardCount() {
        return this.getIntProperty(ELASTIC_SEARCH_INDEX_SHARD_COUNT_PROPERTY_NAME, 5);
    }

    default public int getElasticSearchIndexReplicationCount() {
        return this.getIntProperty(ELASTIC_SEARCH_INDEX_REPLICAS_COUNT_PROPERTY_NAME, 1);
    }

    default public int getElasticSearchTasklogLimit() {
        return this.getIntProperty(ELASTIC_SEARCH_TASK_LOG_RESULT_LIMIT, 10);
    }

    public static enum ElasticSearchInstanceType {
        MEMORY,
        EXTERNAL;

    }
}

