/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc;

import conductor.com.carrotsearch.hppc.BitMixer;
import conductor.com.carrotsearch.hppc.HashOrderMixing;
import conductor.com.carrotsearch.hppc.ShortFloatHashMap;

public class ShortFloatScatterMap
extends ShortFloatHashMap {
    public ShortFloatScatterMap() {
        this(4);
    }

    public ShortFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortFloatScatterMap from(short[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortFloatScatterMap map = new ShortFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

