/*
 * Decompiled with CFR 0.152.
 */
package conductor.io.netty.handler.codec.http.websocketx;

import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.handler.codec.MessageToMessageDecoder;
import conductor.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import conductor.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import conductor.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame> {
    private final boolean dropPongFrames;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean dropPongFrames) {
        this.dropPongFrames = dropPongFrames;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush(new PongWebSocketFrame(frame.content()));
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            return;
        }
        out.add(frame.retain());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
        ctx.close();
    }
}

