/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import java.io.IOException;

public abstract class FilteringTokenFilter
extends TokenFilter {
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int skippedPositions;

    public FilteringTokenFilter(TokenStream in) {
        super(in);
    }

    protected abstract boolean accept() throws IOException;

    @Override
    public final boolean incrementToken() throws IOException {
        this.skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (this.accept()) {
                if (this.skippedPositions != 0) {
                    this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
                }
                return true;
            }
            this.skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.skippedPositions = 0;
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }
}

