/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import java.io.IOException;

public final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;
    private final boolean consumeAllTokens;

    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        this(input, maxStartOffset, false);
    }

    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset, boolean consumeAllTokens) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
        this.consumeAllTokens = consumeAllTokens;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.offsetAttrib.startOffset() <= this.maxStartOffset) {
            return true;
        }
        if (this.consumeAllTokens) {
            while (this.input.incrementToken()) {
            }
        }
        return false;
    }
}

