/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs;

import conductor.org.apache.lucene.codecs.DocValuesConsumer;
import conductor.org.apache.lucene.codecs.DocValuesProducer;
import conductor.org.apache.lucene.index.SegmentReadState;
import conductor.org.apache.lucene.index.SegmentWriteState;
import conductor.org.apache.lucene.util.NamedSPILoader;
import java.io.IOException;
import java.util.Set;

public abstract class DocValuesFormat
implements NamedSPILoader.NamedSPI {
    private final String name;

    protected DocValuesFormat(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    public abstract DocValuesConsumer fieldsConsumer(SegmentWriteState var1) throws IOException;

    public abstract DocValuesProducer fieldsProducer(SegmentReadState var1) throws IOException;

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return "DocValuesFormat(name=" + this.name + ")";
    }

    public static DocValuesFormat forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Set<String> availableDocValuesFormats() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadDocValuesFormats(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    private static final class Holder {
        private static final NamedSPILoader<DocValuesFormat> LOADER = new NamedSPILoader<DocValuesFormat>(DocValuesFormat.class);

        private Holder() {
        }

        static NamedSPILoader<DocValuesFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a DocValuesFormat by name before all formats could be initialized. This likely happens if you call DocValuesFormat#forName from a DocValuesFormat's ctor.");
            }
            return LOADER;
        }
    }
}

