/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs.compressing;

import conductor.org.apache.lucene.codecs.StoredFieldsFormat;
import conductor.org.apache.lucene.codecs.StoredFieldsReader;
import conductor.org.apache.lucene.codecs.StoredFieldsWriter;
import conductor.org.apache.lucene.codecs.compressing.CompressingStoredFieldsReader;
import conductor.org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import conductor.org.apache.lucene.codecs.compressing.CompressionMode;
import conductor.org.apache.lucene.index.FieldInfos;
import conductor.org.apache.lucene.index.SegmentInfo;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.IOContext;
import java.io.IOException;

public class CompressingStoredFieldsFormat
extends StoredFieldsFormat {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final int blockSize;

    public CompressingStoredFieldsFormat(String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this(formatName, "", compressionMode, chunkSize, maxDocsPerChunk, blockSize);
    }

    public CompressingStoredFieldsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        if (maxDocsPerChunk < 1) {
            throw new IllegalArgumentException("maxDocsPerChunk must be >= 1");
        }
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = blockSize;
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new CompressingStoredFieldsReader(directory, si, this.segmentSuffix, fn, context, this.formatName, this.compressionMode);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new CompressingStoredFieldsWriter(directory, si, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockSize=" + this.blockSize + ")";
    }
}

