/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs.compressing;

import conductor.org.apache.lucene.codecs.TermVectorsFormat;
import conductor.org.apache.lucene.codecs.TermVectorsReader;
import conductor.org.apache.lucene.codecs.TermVectorsWriter;
import conductor.org.apache.lucene.codecs.compressing.CompressingTermVectorsReader;
import conductor.org.apache.lucene.codecs.compressing.CompressingTermVectorsWriter;
import conductor.org.apache.lucene.codecs.compressing.CompressionMode;
import conductor.org.apache.lucene.index.FieldInfos;
import conductor.org.apache.lucene.index.SegmentInfo;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.IOContext;
import java.io.IOException;

public class CompressingTermVectorsFormat
extends TermVectorsFormat {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int blockSize;

    public CompressingTermVectorsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int blockSize) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = blockSize;
    }

    @Override
    public final TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new CompressingTermVectorsReader(directory, segmentInfo, this.segmentSuffix, fieldInfos, context, this.formatName, this.compressionMode);
    }

    @Override
    public final TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        return new CompressingTermVectorsWriter(directory, segmentInfo, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.blockSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", blockSize=" + this.blockSize + ")";
    }
}

