/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.RangeFieldQuery;
import conductor.org.apache.lucene.geo.GeoEncodingUtils;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.NumericUtils;

public class LatLonBoundingBox
extends Field {
    public static final int BYTES = 4;

    public LatLonBoundingBox(String name, double minLat, double minLon, double maxLat, double maxLon) {
        super(name, LatLonBoundingBox.getType(2));
        this.setRangeValues(minLat, minLon, maxLat, maxLon);
    }

    static FieldType getType(int geoDimensions) {
        FieldType ft = new FieldType();
        ft.setDimensions(geoDimensions * 2, 4);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(double minLat, double minLon, double maxLat, double maxLon) {
        byte[] bytes;
        LatLonBoundingBox.checkArgs(minLat, minLon, maxLat, maxLon);
        if (this.fieldsData == null) {
            bytes = new byte[16];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        LatLonBoundingBox.encode(minLat, minLon, bytes, 0);
        LatLonBoundingBox.encode(maxLat, maxLon, bytes, 8);
    }

    static void checkArgs(double minLat, double minLon, double maxLat, double maxLon) {
        if (minLon > maxLon) {
            throw new IllegalArgumentException("cannot have minLon [" + minLon + "] exceed maxLon [" + maxLon + "].");
        }
        if (minLat > maxLat) {
            throw new IllegalArgumentException("cannot have minLat [" + minLat + "] exceed maxLat [" + maxLat + "].");
        }
    }

    public static Query newIntersectsQuery(String field, double minLat, double minLon, double maxLat, double maxLon) {
        return LatLonBoundingBox.newRangeQuery(field, minLat, minLon, maxLat, maxLon, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newWithinQuery(String field, double minLat, double minLon, double maxLat, double maxLon) {
        return LatLonBoundingBox.newRangeQuery(field, minLat, minLon, maxLat, maxLon, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newContainsQuery(String field, double minLat, double minLon, double maxLat, double maxLon) {
        return LatLonBoundingBox.newRangeQuery(field, minLat, minLon, maxLat, maxLon, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newCrossesQuery(String field, double minLat, double minLon, double maxLat, double maxLon) {
        return LatLonBoundingBox.newRangeQuery(field, minLat, minLon, maxLat, maxLon, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRangeQuery(String field, double minLat, double minLon, double maxLat, double maxLon, RangeFieldQuery.QueryType queryType) {
        LatLonBoundingBox.checkArgs(minLat, minLon, maxLat, maxLon);
        return new RangeFieldQuery(field, LatLonBoundingBox.encode(minLat, minLon, maxLat, maxLon), 2, queryType){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return LatLonBoundingBox.toString(ranges, dimension);
            }
        };
    }

    static byte[] encode(double minLat, double minLon, double maxLat, double maxLon) {
        byte[] b = new byte[16];
        LatLonBoundingBox.encode(minLat, minLon, b, 0);
        LatLonBoundingBox.encode(maxLat, maxLon, b, 8);
        return b;
    }

    static void encode(double lat, double lon, byte[] result, int offset) {
        if (result == null) {
            result = new byte[16];
        }
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(lat), result, offset);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(lon), result, offset + 4);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        sb.append('[');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        sb.append(LatLonBoundingBox.toString(b, 0));
        sb.append(',');
        sb.append(LatLonBoundingBox.toString(b, 1));
        sb.append(']');
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        double lon;
        double lat;
        switch (dimension) {
            case 0: {
                lat = GeoEncodingUtils.decodeLatitude(ranges, 0);
                lon = GeoEncodingUtils.decodeLongitude(ranges, 4);
                break;
            }
            case 1: {
                lat = GeoEncodingUtils.decodeLatitude(ranges, 8);
                lon = GeoEncodingUtils.decodeLongitude(ranges, 12);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid dimension [" + dimension + "] in toString");
            }
        }
        return lat + "," + lon;
    }
}

