/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queries.payloads;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermContext;
import conductor.org.apache.lucene.queries.payloads.PayloadDecoder;
import conductor.org.apache.lucene.queries.payloads.PayloadFunction;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.search.spans.FilterSpans;
import conductor.org.apache.lucene.search.spans.SpanCollector;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanScorer;
import conductor.org.apache.lucene.search.spans.SpanWeight;
import conductor.org.apache.lucene.search.spans.Spans;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;
    private final PayloadDecoder decoder;
    private final boolean includeSpanScore;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, PayloadDecoder decoder, boolean includeSpanScore) {
        this.wrappedQuery = Objects.requireNonNull(wrappedQuery);
        this.function = Objects.requireNonNull(function);
        this.decoder = decoder;
        this.includeSpanScore = includeSpanScore;
    }

    @Deprecated
    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, boolean includeSpanScore) {
        this(wrappedQuery, function, null, includeSpanScore);
    }

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, PayloadDecoder decoder) {
        this(wrappedQuery, function, decoder, true);
    }

    @Deprecated
    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function) {
        this(wrappedQuery, function, true);
    }

    @Override
    public String getField() {
        return this.wrappedQuery.getField();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query matchRewritten = this.wrappedQuery.rewrite(reader);
        if (this.wrappedQuery != matchRewritten && matchRewritten instanceof SpanQuery) {
            return new PayloadScoreQuery((SpanQuery)matchRewritten, this.function, this.decoder, this.includeSpanScore);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PayloadScoreQuery(");
        buffer.append(this.wrappedQuery.toString(field));
        buffer.append(", function: ");
        buffer.append(this.function.getClass().getSimpleName());
        buffer.append(", includeSpanScore: ");
        buffer.append(this.includeSpanScore);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, needsScores, boost);
        if (!needsScores) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight, boost);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PayloadScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PayloadScoreQuery other) {
        return this.wrappedQuery.equals(other.wrappedQuery) && this.function.equals(other.function) && this.includeSpanScore == other.includeSpanScore && Objects.equals(this.decoder, other.decoder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrappedQuery, this.function, this.decoder, this.includeSpanScore);
    }

    @Deprecated
    private static class SimilarityPayloadDecoder
    implements PayloadDecoder {
        final Similarity.SimScorer docScorer;

        public SimilarityPayloadDecoder(Similarity.SimScorer docScorer) {
            this.docScorer = docScorer;
        }

        @Override
        public float computePayloadFactor(int docID, int startPosition, int endPosition, BytesRef payload) {
            if (payload == null) {
                return 0.0f;
            }
            return this.docScorer.computePayloadFactor(docID, startPosition, endPosition, payload);
        }

        @Override
        public float computePayloadFactor(BytesRef payload) {
            throw new UnsupportedOperationException();
        }
    }

    private class PayloadSpanScorer
    extends SpanScorer {
        private final PayloadSpans spans;

        private PayloadSpanScorer(SpanWeight weight, PayloadSpans spans, Similarity.SimScorer docScorer) throws IOException {
            super(weight, spans, docScorer);
            this.spans = spans;
        }

        protected float getPayloadScore() {
            return PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
        }

        protected Explanation getPayloadExplanation() {
            return PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        @Override
        protected float scoreCurrentDoc() throws IOException {
            if (PayloadScoreQuery.this.includeSpanScore) {
                return this.getSpanScore() * this.getPayloadScore();
            }
            return this.getPayloadScore();
        }
    }

    private class PayloadSpans
    extends FilterSpans
    implements SpanCollector {
        private final PayloadDecoder decoder;
        public int payloadsSeen;
        public float payloadScore;

        private PayloadSpans(Spans in, PayloadDecoder decoder) {
            super(in);
            this.decoder = decoder;
        }

        @Override
        protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
            return FilterSpans.AcceptStatus.YES;
        }

        @Override
        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            float payloadFactor = this.decoder.computePayloadFactor(this.docID(), this.in.startPosition(), this.in.endPosition(), payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.in.startPosition(), this.in.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        @Override
        public void reset() {
        }

        @Override
        protected void doCurrentSpans() throws IOException {
            this.in.collect(this);
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight, float boost) throws IOException {
            super(PayloadScoreQuery.this, searcher, null, boost);
            this.innerWeight = innerWeight;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.innerWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        @Override
        public SpanScorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            Similarity.SimScorer docScorer = this.innerWeight.getSimScorer(context);
            PayloadSpans payloadSpans = new PayloadSpans(spans, PayloadScoreQuery.this.decoder == null ? new SimilarityPayloadDecoder(docScorer) : PayloadScoreQuery.this.decoder);
            return new PayloadSpanScorer(this, payloadSpans, docScorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.innerWeight.isCacheable(ctx);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.innerWeight.extractTerms(terms);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            PayloadSpanScorer scorer = (PayloadSpanScorer)this.scorer(context);
            if (scorer == null || scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            scorer.score();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            if (PayloadScoreQuery.this.includeSpanScore) {
                SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
                Explanation innerExpl = innerWeight.explain(context, doc);
                return Explanation.match(scorer.scoreCurrentDoc(), "PayloadSpanQuery, product of:", innerExpl, payloadExpl);
            }
            return scorer.getPayloadExplanation();
        }
    }
}

