/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.grouping;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.SimpleCollector;
import conductor.org.apache.lucene.search.grouping.GroupSelector;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AllGroupsCollector<T>
extends SimpleCollector {
    private final GroupSelector<T> groupSelector;
    private final Set<T> groups = new HashSet<T>();

    public AllGroupsCollector(GroupSelector<T> groupSelector) {
        this.groupSelector = groupSelector;
    }

    public int getGroupCount() {
        return this.getGroups().size();
    }

    public Collection<T> getGroups() {
        return this.groups;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.groupSelector.setNextReader(context);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.groupSelector.advanceTo(doc);
        if (this.groups.contains(this.groupSelector.currentValue())) {
            return;
        }
        this.groups.add(this.groupSelector.copyValue());
    }

    @Override
    public boolean needsScores() {
        return false;
    }
}

