/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.SmallFloat;
import java.io.IOException;
import java.util.ArrayList;

public abstract class TFIDFSimilarity
extends Similarity {
    static final float[] OLD_NORM_TABLE = new float[256];
    protected boolean discountOverlaps = true;

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    public abstract float tf(float var1);

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount() == -1L ? collectionStats.maxDoc() : collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match(idf, "idf(docFreq=" + df + ", docCount=" + docCount + ")", new Explanation[0]);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        double idf = 0.0;
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            subs.add(idfExplain);
            idf += (double)idfExplain.getValue();
        }
        return Explanation.match((float)idf, "idf(), sum of:", subs);
    }

    public abstract float idf(long var1, long var3);

    public abstract float lengthNorm(int var1);

    @Override
    public final long computeNorm(FieldInvertState state) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        if (state.getIndexCreatedVersionMajor() >= 7) {
            return SmallFloat.intToByte4(numTerms);
        }
        return SmallFloat.floatToByte315(this.lengthNorm(numTerms));
    }

    @Deprecated
    public abstract float sloppyFreq(int var1);

    @Deprecated
    public abstract float scorePayload(int var1, int var2, int var3, BytesRef var4);

    @Override
    public final Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float[] normTable = new float[256];
        for (int i = 1; i < 256; ++i) {
            float norm;
            int length = SmallFloat.byte4ToInt((byte)i);
            normTable[i] = norm = this.lengthNorm(length);
        }
        normTable[0] = 1.0f / normTable[255];
        return new IDFStats(collectionStats.field(), boost, idf, normTable);
    }

    @Override
    public final Similarity.SimScorer simScorer(Similarity.SimWeight stats, LeafReaderContext context) throws IOException {
        IDFStats idfstats = (IDFStats)stats;
        float[] normTable = context.reader().getMetaData().getCreatedVersionMajor() >= 7 ? idfstats.normTable : OLD_NORM_TABLE;
        return new TFIDFSimScorer(idfstats, context.reader().getNormValues(idfstats.field), normTable);
    }

    private Explanation explainField(int doc, Explanation freq, IDFStats stats, NumericDocValues norms, float[] normTable) throws IOException {
        Explanation tfExplanation = Explanation.match(this.tf(freq.getValue()), "tf(freq=" + freq.getValue() + "), with freq of:", freq);
        float norm = norms == null ? 1.0f : (!norms.advanceExact(doc) ? 0.0f : normTable[(int)(norms.longValue() & 0xFFL)]);
        Explanation fieldNormExpl = Explanation.match(norm, "fieldNorm(doc=" + doc + ")", new Explanation[0]);
        return Explanation.match(tfExplanation.getValue() * stats.idf.getValue() * fieldNormExpl.getValue(), "fieldWeight in " + doc + ", product of:", tfExplanation, stats.idf, fieldNormExpl);
    }

    private Explanation explainScore(int doc, Explanation freq, IDFStats stats, NumericDocValues norms, float[] normTable) throws IOException {
        Explanation queryExpl = Explanation.match(stats.boost, "boost", new Explanation[0]);
        Explanation fieldExpl = this.explainField(doc, freq, stats, norms, normTable);
        if (stats.boost == 1.0f) {
            return fieldExpl;
        }
        return Explanation.match(queryExpl.getValue() * fieldExpl.getValue(), "score(doc=" + doc + ",freq=" + freq.getValue() + "), product of:", queryExpl, fieldExpl);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            TFIDFSimilarity.OLD_NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
        }
    }

    static class IDFStats
    extends Similarity.SimWeight {
        private final String field;
        private final Explanation idf;
        private final float boost;
        private final float queryWeight;
        final float[] normTable;

        public IDFStats(String field, float boost, Explanation idf, float[] normTable) {
            this.field = field;
            this.idf = idf;
            this.boost = boost;
            this.queryWeight = boost * idf.getValue();
            this.normTable = normTable;
        }
    }

    private final class TFIDFSimScorer
    extends Similarity.SimScorer {
        private final IDFStats stats;
        private final float weightValue;
        private final NumericDocValues norms;
        private final float[] normTable;

        TFIDFSimScorer(IDFStats stats, NumericDocValues norms, float[] normTable) throws IOException {
            this.stats = stats;
            this.weightValue = stats.queryWeight;
            this.norms = norms;
            this.normTable = normTable;
        }

        @Override
        public float score(int doc, float freq) throws IOException {
            float raw = TFIDFSimilarity.this.tf(freq) * this.weightValue;
            if (this.norms == null) {
                return raw;
            }
            float normValue = this.norms.advanceExact(doc) ? this.normTable[(int)(this.norms.longValue() & 0xFFL)] : 0.0f;
            return raw * normValue;
        }

        @Override
        public float computeSlopFactor(int distance) {
            return TFIDFSimilarity.this.sloppyFreq(distance);
        }

        @Override
        public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
            return TFIDFSimilarity.this.scorePayload(doc, start, end, payload);
        }

        @Override
        public Explanation explain(int doc, Explanation freq) throws IOException {
            return TFIDFSimilarity.this.explainScore(doc, freq, this.stats, this.norms, this.normTable);
        }
    }
}

