/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.store;

import conductor.org.apache.lucene.store.BufferedIndexInput;
import conductor.org.apache.lucene.store.FSDirectory;
import conductor.org.apache.lucene.store.FSLockFactory;
import conductor.org.apache.lucene.store.IOContext;
import conductor.org.apache.lucene.store.IndexInput;
import conductor.org.apache.lucene.store.LockFactory;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Path;

public class WindowsDirectory
extends FSDirectory {
    private static final int DEFAULT_BUFFERSIZE = 4096;

    public WindowsDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public WindowsDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        return new WindowsIndexInput(this.getDirectory().resolve(name), Math.max(BufferedIndexInput.bufferSize(context), 4096));
    }

    private static native long open(String var0) throws IOException;

    private static native int read(long var0, byte[] var2, int var3, int var4, long var5) throws IOException;

    private static native void close(long var0) throws IOException;

    private static native long length(long var0) throws IOException;

    static {
        System.loadLibrary("WindowsDirectory");
    }

    static class WindowsIndexInput
    extends BufferedIndexInput {
        private final long fd;
        private final long length;
        boolean isClone;
        boolean isOpen;

        public WindowsIndexInput(Path file, int bufferSize) throws IOException {
            super("WindowsIndexInput(path=\"" + file + "\")", bufferSize);
            this.fd = WindowsDirectory.open(file.toString());
            this.length = WindowsDirectory.length(this.fd);
            this.isOpen = true;
        }

        @Override
        protected void readInternal(byte[] b, int offset, int length) throws IOException {
            int bytesRead;
            try {
                bytesRead = WindowsDirectory.read(this.fd, b, offset, length, this.getFilePointer());
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + ": " + this, ioe);
            }
            if (bytesRead != length) {
                throw new EOFException("read past EOF: " + this);
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.isClone && this.isOpen) {
                WindowsDirectory.close(this.fd);
                this.isOpen = false;
            }
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public WindowsIndexInput clone() {
            WindowsIndexInput clone = (WindowsIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }
    }
}

