/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.reroute;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.cluster.ClusterModule;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;

public class ClusterRerouteResponse
extends AcknowledgedResponse
implements ToXContentObject {
    private ClusterState state;
    private RoutingExplanations explanations;

    ClusterRerouteResponse() {
    }

    ClusterRerouteResponse(boolean acknowledged, ClusterState state, RoutingExplanations explanations) {
        super(acknowledged);
        this.state = state;
        this.explanations = explanations;
    }

    public ClusterState getState() {
        return this.state;
    }

    public RoutingExplanations getExplanations() {
        return this.explanations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.readFrom(in);
            this.state = ClusterState.readFrom(in, null);
            this.explanations = RoutingExplanations.readFrom(in);
        } else {
            this.state = ClusterState.readFrom(in, null);
            this.acknowledged = in.readBoolean();
            this.explanations = RoutingExplanations.readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.writeTo(out);
            this.state.writeTo(out);
            RoutingExplanations.writeTo(this.explanations, out);
        } else {
            if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
                this.state.writeTo(out);
            } else {
                ClusterModule.filterCustomsForPre63Clients(this.state).writeTo(out);
            }
            out.writeBoolean(this.acknowledged);
            RoutingExplanations.writeTo(this.explanations, out);
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("state");
        this.state.toXContent(builder, params);
        builder.endObject();
        if (params.paramAsBoolean("explain", false)) {
            this.explanations.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
    }
}

