/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.stats;

import conductor.org.elasticsearch.action.admin.indices.stats.CommonStats;
import conductor.org.elasticsearch.action.admin.indices.stats.ShardStats;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class IndexShardStats
implements Iterable<ShardStats>,
Streamable {
    private ShardId shardId;
    private ShardStats[] shards;
    private CommonStats total = null;
    private CommonStats primary = null;

    private IndexShardStats() {
    }

    public IndexShardStats(ShardId shardId, ShardStats[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    @Override
    public Iterator<ShardStats> iterator() {
        return Arrays.stream(this.shards).iterator();
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimary() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        int shardSize = in.readVInt();
        this.shards = new ShardStats[shardSize];
        for (int i = 0; i < shardSize; ++i) {
            this.shards[i] = ShardStats.readShardStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardStats stats : this.shards) {
            stats.writeTo(out);
        }
    }

    public static IndexShardStats readIndexShardStats(StreamInput in) throws IOException {
        IndexShardStats indexShardStats = new IndexShardStats();
        indexShardStats.readFrom(in);
        return indexShardStats;
    }
}

