/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.explain;

import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.RoutingMissingException;
import conductor.org.elasticsearch.action.explain.ExplainRequest;
import conductor.org.elasticsearch.action.explain.ExplainResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.index.get.GetResult;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.search.DefaultSearchContext;
import conductor.org.elasticsearch.search.SearchService;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.internal.ShardSearchLocalRequest;
import conductor.org.elasticsearch.search.rescore.RescoreContext;
import conductor.org.elasticsearch.search.rescore.Rescorer;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    private final SearchService searchService;

    @Inject
    public TransportExplainAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/explain", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest::new, "get");
        this.searchService = searchService;
    }

    @Override
    protected void doExecute(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(request, listener);
    }

    @Override
    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(state, request.concreteIndex(), ((ExplainRequest)request.request()).index());
        ((ExplainRequest)request.request()).filteringAlias(aliasFilter);
        if (((ExplainRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((ExplainRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((ExplainRequest)request.request()).type(), ((ExplainRequest)request.request()).id());
        }
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) throws IOException {
        ExplainResponse explainResponse;
        Explanation explanation;
        Engine.GetResult result;
        DefaultSearchContext context;
        block10: {
            block9: {
                Term uidTerm;
                block8: {
                    ShardSearchLocalRequest shardSearchLocalRequest = new ShardSearchLocalRequest(shardId, new String[]{request.type()}, request.nowInMillis, request.filteringAlias());
                    context = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);
                    result = null;
                    uidTerm = ((SearchContext)context).mapperService().createUidTerm(request.type(), request.id());
                    if (uidTerm != null) break block8;
                    ExplainResponse explainResponse2 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), false);
                    Releasables.close(result, context);
                    return explainResponse2;
                }
                result = ((SearchContext)context).indexShard().get(new Engine.Get(false, false, request.type(), request.id(), uidTerm));
                if (result.exists()) break block9;
                ExplainResponse explainResponse3 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), false);
                Releasables.close(result, context);
                return explainResponse3;
            }
            ((SearchContext)context).parsedQuery(((SearchContext)context).getQueryShardContext().toQuery(request.query()));
            ((SearchContext)context).preProcess(true);
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().docBase;
            explanation = ((SearchContext)context).searcher().explain(((SearchContext)context).query(), topLevelDocId);
            for (RescoreContext ctx : ((SearchContext)context).rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, ((SearchContext)context).searcher(), ctx, explanation);
            }
            if (request.storedFields() == null && (request.fetchSourceContext() == null || !request.fetchSourceContext().fetchSource())) break block10;
            GetResult getResult = ((SearchContext)context).indexShard().getService().get(result, request.id(), request.type(), request.storedFields(), request.fetchSourceContext());
            ExplainResponse explainResponse4 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), true, explanation, getResult);
            Releasables.close(result, context);
            return explainResponse4;
        }
        try {
            explainResponse = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), true, explanation);
        }
        catch (IOException e) {
            try {
                throw new ElasticsearchException("Could not explain", (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Releasables.close(result, context);
                throw throwable;
            }
        }
        Releasables.close(result, context);
        return explainResponse;
    }

    @Override
    protected ExplainResponse newResponse() {
        return new ExplainResponse();
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }

    @Override
    protected String getExecutor(ExplainRequest request, ShardId shardId) {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

