/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.main;

import conductor.org.elasticsearch.Build;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.main.MainRequest;
import conductor.org.elasticsearch.action.main.MainResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.node.Node;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private final ClusterService clusterService;

    @Inject
    public TransportMainAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:monitor/main", threadPool, transportService, actionFilters, indexNameExpressionResolver, MainRequest::new);
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        assert (Node.NODE_NAME_SETTING.exists(this.settings));
        boolean available = !clusterState.getBlocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE);
        listener.onResponse(new MainResponse(Node.NODE_NAME_SETTING.get(this.settings), Version.CURRENT, clusterState.getClusterName(), clusterState.metaData().clusterUUID(), Build.CURRENT, available));
    }
}

