/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.HttpEntity;
import conductor.org.apache.http.entity.BufferedHttpEntity;
import conductor.org.apache.http.util.EntityUtils;
import conductor.org.elasticsearch.client.Response;
import java.io.IOException;
import java.util.Locale;

public final class ResponseException
extends IOException {
    private Response response;

    public ResponseException(Response response) throws IOException {
        super(ResponseException.buildMessage(response));
        this.response = response;
    }

    ResponseException(ResponseException e) throws IOException {
        super(e.getMessage(), e);
        this.response = e.getResponse();
    }

    private static String buildMessage(Response response) throws IOException {
        HttpEntity entity;
        String message = String.format(Locale.ROOT, "method [%s], host [%s], URI [%s], status line [%s]", response.getRequestLine().getMethod(), response.getHost(), response.getRequestLine().getUri(), response.getStatusLine().toString());
        if (response.hasWarnings()) {
            message = message + "\nWarnings: " + response.getWarnings();
        }
        if ((entity = response.getEntity()) != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.getHttpResponse().setEntity(entity);
            }
            message = message + "\n" + EntityUtils.toString(entity);
        }
        return message;
    }

    public Response getResponse() {
        return this.response;
    }
}

